/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual;

import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.AbstractContextualSmoother;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.ContextualSmoother;
import edu.northwestern.at.utils.corpuslinguistics.postagger.transitionmatrix.TransitionMatrix;
import edu.northwestern.at.utils.math.Probability;

public class AdditiveContextualSmoother
extends AbstractContextualSmoother
implements ContextualSmoother {
    protected double additiveAdjustmentValue = 0.001;

    public void setPartOfSpeechTagger(PartOfSpeechTagger partOfSpeechTagger) {
        super.setPartOfSpeechTagger(partOfSpeechTagger);
    }

    public double getAdditiveAdjustmentValue() {
        return this.additiveAdjustmentValue;
    }

    public void setAdditiveAdjustmentValue(double additiveAdjustmentValue) {
        this.additiveAdjustmentValue = additiveAdjustmentValue;
    }

    public Probability contextualProbability(String tag, String previousTag) {
        Probability result = null;
        if (this.cachedContextualProbabilities != null) {
            result = (Probability)this.cachedContextualProbabilities.get(previousTag, tag, "*");
        }
        if (result == null) {
            TransitionMatrix transitionMatrix = this.partOfSpeechTagger.getTransitionMatrix();
            Lexicon lexicon = this.partOfSpeechTagger.getLexicon();
            double additiveDenomFactor = this.additiveAdjustmentValue * (double)lexicon.getLexiconSize();
            double prob = ((double)transitionMatrix.getCount(previousTag, tag) + 0.05) / ((double)transitionMatrix.getCount(previousTag) + additiveDenomFactor);
            result = new Probability(prob);
            if (this.cachedContextualProbabilities != null) {
                this.cachedContextualProbabilities.put(previousTag, tag, "*", result);
            }
        }
        return result;
    }

    public Probability contextualProbability(String tag, String previousTag, String previousPreviousTag) {
        Probability result = null;
        if (this.cachedContextualProbabilities != null) {
            result = (Probability)this.cachedContextualProbabilities.get(previousPreviousTag, previousTag, tag);
        }
        if (result == null) {
            TransitionMatrix transitionMatrix = this.partOfSpeechTagger.getTransitionMatrix();
            Lexicon lexicon = this.partOfSpeechTagger.getLexicon();
            double additiveDenomFactor = this.additiveAdjustmentValue * (double)lexicon.getLexiconSize();
            double prob = ((double)transitionMatrix.getCount(previousPreviousTag, previousTag, tag) + this.additiveAdjustmentValue) / ((double)transitionMatrix.getCount(previousPreviousTag, previousTag) + additiveDenomFactor);
            result = new Probability(prob);
            if (this.cachedContextualProbabilities != null) {
                this.cachedContextualProbabilities.put(previousPreviousTag, previousTag, tag, result);
            }
        }
        return result;
    }

    public String toString() {
        return "Using additive contextual smoothing with additive value=" + this.additiveAdjustmentValue + ".";
    }
}

