/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.regexp;

import edu.northwestern.at.utils.corpuslinguistics.postagger.CanTagOneWord;
import edu.northwestern.at.utils.corpuslinguistics.postagger.InvalidRuleException;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.unigram.UnigramTagger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpTagger
extends UnigramTagger
implements PartOfSpeechTagger,
CanTagOneWord {
    protected Pattern[] regexpPatterns;
    protected Matcher[] regexpMatchers;
    protected String[] regexpTags;

    public boolean usesLexicalRules() {
        return true;
    }

    public void setLexicalRules(String[] lexicalRules) throws InvalidRuleException {
        this.regexpPatterns = new Pattern[lexicalRules.length];
        this.regexpMatchers = new Matcher[lexicalRules.length];
        this.regexpTags = new String[lexicalRules.length];
        for (int i = 0; i < lexicalRules.length; ++i) {
            String[] tokens = lexicalRules[i].split("\t");
            this.regexpPatterns[i] = Pattern.compile(tokens[0]);
            this.regexpMatchers[i] = this.regexpPatterns[i].matcher("");
            this.regexpTags[i] = tokens[1];
        }
    }

    public String tagWord(String word) {
        String result = "";
        for (int i = 0; i < this.regexpMatchers.length; ++i) {
            this.regexpMatchers[i].reset(word);
            if (!this.regexpMatchers[i].find()) continue;
            result = this.regexpTags[i];
            break;
        }
        return result;
    }

    public String toString() {
        return "Regular expression tagger";
    }
}

