/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.propernounretagger;

import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.unigram.UnigramTagger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProperNounRetagger
extends UnigramTagger
implements PartOfSpeechRetagger {
    protected static PartOfSpeechTags posTags;

    @Override
    public <T extends AdornedWord> List<T> retagSentence(List<T> sentence) {
        if (posTags == null) {
            posTags = this.getLexicon().getPartOfSpeechTags();
        }
        for (int i = 1; i < sentence.size(); ++i) {
            AdornedWord adornedWord = (AdornedWord)sentence.get(i);
            String spelling = adornedWord.getSpelling();
            boolean isCapitalized = Character.isUpperCase(spelling.charAt(0));
            if (isCapitalized) continue;
            String partsOfSpeech = adornedWord.getPartsOfSpeech();
            if (posTags.isProperNounTag(partsOfSpeech)) {
                adornedWord.setPartsOfSpeech(posTags.getCorrespondingCommonNounTag(partsOfSpeech));
                continue;
            }
            if (!posTags.isProperAdjectiveTag(partsOfSpeech)) continue;
            adornedWord.setPartsOfSpeech(posTags.getAdjectiveTag());
        }
        return sentence;
    }

    @Override
    public boolean canAddOrDeleteWords() {
        return false;
    }

    @Override
    public String toString() {
        return "Proper noun retagger";
    }
}

