/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.hepple;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.postagger.AbstractPartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.InvalidRuleException;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.hepple.Rule;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeppleTagger
extends AbstractPartOfSpeechTagger
implements PartOfSpeechTagger,
PartOfSpeechRetagger {
    protected Map<String, List<Rule>> rules = MapFactory.createNewMap();
    protected static final String staart = "STAART";
    protected static final String[] staartLex = new String[]{"STAART"};
    protected static final AdornedWord staartWordAndTag = new BaseAdornedWord("STAART", "STAART");
    public String[] wordBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[] tagBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[][] lexBuff = new String[][]{staartLex, staartLex, staartLex, staartLex, staartLex, staartLex, staartLex};
    protected boolean debug = false;

    @Override
    public boolean usesContextRules() {
        return true;
    }

    @Override
    public void setContextRules(String[] contextRules) throws InvalidRuleException {
        this.contextRules = contextRules;
        this.rules.clear();
        for (int i = 0; i < this.contextRules.length; ++i) {
            String line = contextRules[i];
            List<String> ruleParts = ListFactory.createNewList();
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                ruleParts.add(tokens.nextToken());
            }
            if (ruleParts.size() < 3) {
                throw new InvalidRuleException(line);
            }
            Rule newRule = this.createNewRule((String)ruleParts.get(2));
            newRule.initialise(ruleParts);
            List<Rule> existingRules = this.rules.get(newRule.from);
            if (existingRules == null) {
                existingRules = ListFactory.createNewList();
                this.rules.put(newRule.from, existingRules);
            }
            existingRules.add(newRule);
        }
    }

    protected Rule createNewRule(String ruleId) throws InvalidRuleException {
        String baseClassName = ClassUtils.packageName(HeppleTagger.class.getName()) + ".rules.Rule_";
        try {
            String ruleClassName = baseClassName + ruleId;
            Class<?> ruleClass = Class.forName(ruleClassName);
            return (Rule)ruleClass.newInstance();
        }
        catch (Exception e) {
            throw new InvalidRuleException("Could not create rule " + ruleId + "!\n" + e.toString());
        }
    }

    @Override
    public <T extends AdornedWord> List<T> tagAdornedWordList(List<T> sentence) {
        int i;
        boolean isFirstWord = true;
        for (i = 0; i < sentence.size(); ++i) {
            AdornedWord newWord = (AdornedWord)sentence.get(i);
            this.oneStep(newWord, isFirstWord, sentence);
            isFirstWord = false;
        }
        for (i = 0; i < 6; ++i) {
            this.oneStep(new BaseAdornedWord(staart), isFirstWord, sentence);
            isFirstWord = false;
        }
        return sentence;
    }

    protected boolean oneStep(AdornedWord word, boolean isFirstWord, List taggedSentence) {
        for (int i = 1; i < 7; ++i) {
            this.wordBuff[i - 1] = this.wordBuff[i];
            this.tagBuff[i - 1] = this.tagBuff[i];
            this.lexBuff[i - 1] = this.lexBuff[i];
        }
        this.wordBuff[6] = word.getSpelling();
        this.lexBuff[6] = this.getPartsOfSpeech(word.getSpelling(), false);
        this.tagBuff[6] = this.lexBuff[6][0];
        if (this.debug) {
            System.out.println("===> word=" + this.wordBuff[3] + " currently tagged " + this.tagBuff[3]);
        }
        boolean done = false;
        while (!done) {
            String currentTag = this.tagBuff[3];
            List<Rule> rulesToApply = this.rules.get(this.lexBuff[3][0]);
            if (rulesToApply != null && rulesToApply.size() > 0) {
                Iterator<Rule> rulesIter = rulesToApply.iterator();
                while (rulesIter.hasNext() && !rulesIter.next().apply(this)) {
                }
            }
            done = true;
        }
        String taggedWord = this.wordBuff[0];
        if (taggedWord != staart) {
            BaseAdornedWord newWord = new BaseAdornedWord(taggedWord, this.tagBuff[0]);
            taggedSentence.add(newWord);
            if (this.wordBuff[1] == staart) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends AdornedWord> List<T> retagSentence(List<T> sentence) {
        List taggedSentence = ListFactory.createNewList();
        Iterator<T> taggedWordsIter = sentence.iterator();
        boolean isFirstWord = true;
        while (taggedWordsIter.hasNext()) {
            AdornedWord nextWord = (AdornedWord)taggedWordsIter.next();
            this.oneRetagStep(nextWord, isFirstWord, taggedSentence);
            isFirstWord = false;
        }
        for (int i = 0; i < 6; ++i) {
            this.oneRetagStep(staartWordAndTag, isFirstWord, taggedSentence);
            isFirstWord = false;
        }
        return taggedSentence;
    }

    protected <T extends AdornedWord> boolean oneRetagStep(T adornedWord, boolean isFirstWord, List<T> taggedSentence) {
        String taggedWord;
        for (int i = 1; i < 7; ++i) {
            this.wordBuff[i - 1] = this.wordBuff[i];
            this.tagBuff[i - 1] = this.tagBuff[i];
            this.lexBuff[i - 1] = this.lexBuff[i];
        }
        this.wordBuff[6] = adornedWord.getSpelling();
        this.lexBuff[6] = this.getPartsOfSpeech(adornedWord.getSpelling(), false);
        this.tagBuff[6] = adornedWord.getPartsOfSpeech();
        List<Rule> rulesToApply = this.rules.get(this.lexBuff[3][0]);
        if (rulesToApply != null && rulesToApply.size() > 0) {
            Iterator<Rule> rulesIter = rulesToApply.iterator();
            while (rulesIter.hasNext() && !rulesIter.next().apply(this)) {
            }
        }
        if ((taggedWord = this.wordBuff[0]) != staart) {
            BaseAdornedWord aWord = new BaseAdornedWord(taggedWord, this.tagBuff[0]);
            taggedSentence.add(aWord);
            if (this.wordBuff[1] == staart) {
                return true;
            }
        }
        return false;
    }

    protected String[] getPartsOfSpeech(String word, boolean isFirstWord) {
        String[] result = new String[]{};
        if (word == staart) {
            return staartLex;
        }
        List<String> categories = this.getTagsForWord(word);
        if (categories != null) {
            String largestCategory = this.getMostCommonTag(word);
            result = new String[categories.size()];
            result[0] = largestCategory;
            if (categories.size() > 1) {
                int k = 1;
                for (String category : categories) {
                    if (category.equals(largestCategory)) continue;
                    result[k++] = category;
                }
            }
        }
        return result;
    }

    @Override
    public boolean canAddOrDeleteWords() {
        return false;
    }

    public String toString() {
        return "Hepple tagger";
    }
}

