/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.guesser;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.DefaultPartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;

public class PartOfSpeechGuesserFactory {
    public PartOfSpeechGuesser newPartOfSpeechGuesser() {
        String className = System.getProperty("partofspeechguesser.class");
        if (className == null) {
            className = "DefaultPartOfSpeechGuesser";
        }
        return this.newPartOfSpeechGuesser(className);
    }

    public PartOfSpeechGuesser newPartOfSpeechGuesser(String className) {
        PartOfSpeechGuesser partOfSpeechGuesser = null;
        try {
            partOfSpeechGuesser = (PartOfSpeechGuesser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                partOfSpeechGuesser = (PartOfSpeechGuesser)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create part of speech guesser of class " + fixedClassName + ", using default.");
                partOfSpeechGuesser = new DefaultPartOfSpeechGuesser();
            }
        }
        return partOfSpeechGuesser;
    }
}

