/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.guesser;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.AbstractPartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPartOfSpeechGuesser
extends AbstractPartOfSpeechGuesser
implements PartOfSpeechGuesser {
    @Override
    public Map<String, MutableInteger> guessPartsOfSpeech(String theWord) {
        String word;
        Map<String, MutableInteger> result;
        if (this.debug) {
            this.logger.logDebug("guessPartsOfSpeech: word=" + theWord);
        }
        if ((result = this.checkCachedWord(word = theWord)) != null) {
            if (this.debug) {
                this.logger.logDebug("guessPartsOfSpeech:   in cache, pos=" + result);
            }
            if (result.size() == 0) {
                result = null;
            }
        }
        if (result != null) {
            return result;
        }
        if (this.wordLexicon != null) {
            if (this.wordLexicon.containsEntry(word)) {
                result = this.clonePosTagMap(this.wordLexicon.getCategoryCountsForEntry(word));
            }
            if (result != null && this.debug) {
                this.logger.logDebug("guessPartsOfSpeech:   in word lexicon, pos=" + result);
            }
            if (result != null) {
                return result;
            }
            if (CharUtils.allLettersCapital(word)) {
                if (this.wordLexicon.containsEntry(word = CharUtils.capitalizeFirstLetter(word))) {
                    result = this.clonePosTagMap(this.wordLexicon.getCategoryCountsForEntry(word));
                }
                if (result != null && this.debug) {
                    this.logger.logDebug("guessPartsOfSpeech:   recapitalized in word lexicon, pos=" + result);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        if ((result = this.checkPunctuation(word)) != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is punctuation, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkSymbol(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is symbol, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkNumber(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is number, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkCurrency(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is currency, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkAbbreviation(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is abbreviation, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkRomanNumeral(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is Roman numeral, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkHyphenatedWord(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is hyphenated word, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        String[] standardSpellings = this.getStandardizedSpellings(word);
        if (standardSpellings != null) {
            result = this.checkStandardSpellings(word, standardSpellings);
            if (result != null && this.debug) {
                this.logger.logDebug("guessPartsOfSpeech:   from standard spellings, pos=" + result);
            }
            if (result != null) {
                return result;
            }
        }
        if ((result = this.checkName(word)) != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is name, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkPossessiveNoun(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is possessive, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.checkAuxiliaryWordLists(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   from auxiliary word lists, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        if (this.suffixLexicon != null) {
            result = this.checkSuffixes(word, standardSpellings);
            if (result != null && this.debug) {
                this.logger.logDebug("guessPartsOfSpeech:   from suffix analysis, pos=" + result);
            }
            if (result != null) {
                return result;
            }
        }
        if ((result = this.checkAllUpperCase(word)) != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   is all uppercase, pos=" + result);
        }
        if (result != null) {
            return result;
        }
        result = this.getNoun(word);
        if (result != null && this.debug) {
            this.logger.logDebug("guessPartsOfSpeech:   assigning noun, pos=" + result);
        }
        return result;
    }

    @Override
    public Map<String, MutableInteger> guessPartsOfSpeech(List<String> sentence, int wordIndex) {
        String word = sentence.get(wordIndex);
        return this.guessPartsOfSpeech(word);
    }
}

