/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.bigram;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.Map2D;
import edu.northwestern.at.utils.Map2DFactory;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.postagger.AbstractPartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.Viterbi;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.ContextualSmootherFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.lexical.LexicalSmootherFactory;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import edu.northwestern.at.utils.math.Probability;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigramTagger
extends AbstractPartOfSpeechTagger
implements PartOfSpeechTagger {
    protected boolean debug = false;
    protected Map2D<String, String, Probability> contextualProbabilities = Map2DFactory.createNewMap2D();
    protected int beamSearchRejections = 0;
    protected Viterbi viterbi = new Viterbi();

    public BigramTagger() {
        this.lexicalSmoother = new LexicalSmootherFactory().newLexicalSmoother();
        this.lexicalSmoother.setPartOfSpeechTagger(this);
        this.contextualSmoother = new ContextualSmootherFactory().newContextualSmoother();
        this.contextualSmoother.setPartOfSpeechTagger(this);
    }

    @Override
    public boolean usesTransitionProbabilities() {
        return true;
    }

    @Override
    public List<List<AdornedWord>> tagSentences(List<List<String>> sentences) {
        List<List<AdornedWord>> result = super.tagSentences(sentences);
        if (this.debug) {
            this.logger.logDebug("      # of cached lexical probabilties   : " + this.lexicalSmoother.cachedProbabilitiesCount());
            this.logger.logDebug("      # of cached contextual probabilties: " + this.contextualSmoother.cachedProbabilitiesCount());
            this.logger.logDebug("   # of states rejected by beam search: " + this.beamSearchRejections);
        }
        return result;
    }

    @Override
    public <T extends AdornedWord> List<T> tagAdornedWordList(List<T> taggedSentence) {
        this.viterbi.reset();
        List<String> previousTags = ListFactory.createNewList();
        previousTags.add(".");
        int wordIndex = 0;
        Iterator<T> wordsIter = taggedSentence.iterator();
        List<String> tags = null;
        while (wordsIter.hasNext()) {
            AdornedWord word = (AdornedWord)wordsIter.next();
            tags = this.getTagsForWord(word.getStandardSpelling());
            previousTags = this.processWord(wordIndex++, word.getStandardSpelling(), previousTags, tags);
        }
        List<String> optimalTags = this.viterbi.optimalTags(wordIndex, tags);
        wordIndex = 0;
        for (AdornedWord word : taggedSentence) {
            word.setPartsOfSpeech(optimalTags.get(wordIndex++));
        }
        this.beamSearchRejections += this.viterbi.getBeamSearchRejections();
        return taggedSentence;
    }

    protected List<String> processWord(int wordIndex, String word, List<String> previousTags, List<String> tags) {
        this.contextualProbabilities.clear();
        int nTags = tags.size();
        Probability[] lexicalProbs = new Probability[nTags];
        for (int i = 0; i < nTags; ++i) {
            lexicalProbs[i] = this.lexicalSmoother.lexicalProbability(word, tags.get(i));
            for (int j = 0; j < previousTags.size(); ++j) {
                this.contextualProbabilities.put((String)((Object)((Comparable)((Object)tags.get(i)))), (String)((Object)((Comparable)((Object)previousTags.get(j)))), this.contextualSmoother.contextualProbability(tags.get(i), previousTags.get(j)));
            }
        }
        return this.viterbi.updateScore(wordIndex, lexicalProbs, this.contextualProbabilities, tags, previousTags);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
        ((UsesLogger)((Object)this.lexicalSmoother)).setLogger(logger);
        ((UsesLogger)((Object)this.contextualSmoother)).setLogger(logger);
        this.viterbi.setLogger(logger);
    }

    public String toString() {
        return "Bigram tagger";
    }
}

