/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.trigram.TrigramTagger;
import java.util.Map;

public class PartOfSpeechTaggerFactory {
    protected static Map<String, String> taggerClassMap = MapFactory.createNewMap();

    public PartOfSpeechTagger newPartOfSpeechTagger() {
        String className = System.getProperty("partofspeechtagger.class");
        if (className == null) {
            className = ClassUtils.packageName(this.getClass().getName()) + ".trigramtagger.TrigramTagger";
        }
        return this.newPartOfSpeechTagger(className);
    }

    public PartOfSpeechTagger newPartOfSpeechTagger(String className) {
        PartOfSpeechTagger partOfSpeechTagger = null;
        try {
            partOfSpeechTagger = (PartOfSpeechTagger)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = taggerClassMap.get(className);
            if (fixedClassName != null) {
                try {
                    partOfSpeechTagger = (PartOfSpeechTagger)Class.forName(fixedClassName).newInstance();
                }
                catch (Exception e2) {
                    System.err.println("Unable to create part of speech tagger of class " + fixedClassName + ", using trigram tagger.");
                    partOfSpeechTagger = new TrigramTagger();
                }
            }
            System.err.println("Unable to create part of speech tagger of class " + className + ", using trigram tagger.");
            partOfSpeechTagger = new TrigramTagger();
        }
        return partOfSpeechTagger;
    }

    static {
        String classPrefix = ClassUtils.packageName(PartOfSpeechTaggerFactory.class.getName());
        taggerClassMap.put("AffixTagger", classPrefix + ".affix.AffixTagger");
        taggerClassMap.put("BigramTagger", classPrefix + ".bigram.BigramTagger");
        taggerClassMap.put("BigramHybridTagger", classPrefix + ".bigramhybrid.BigramHybridTagger");
        taggerClassMap.put("HeppleTagger", classPrefix + ".hepple.HeppleTagger");
        taggerClassMap.put("RegexpTagger", classPrefix + ".regexp.RegexpTagger");
        taggerClassMap.put("SimpleTagger", classPrefix + ".simple.SimpleTagger");
        taggerClassMap.put("SimpleRuleBasedTagger", classPrefix + ".simplerulebased.SimpleRuleBasedTagger");
        taggerClassMap.put("SuffixTagger", classPrefix + ".suffix.SuffixTagger");
        taggerClassMap.put("TrigramTagger", classPrefix + ".trigram.TrigramTagger");
        taggerClassMap.put("TrigramHybridTagger", classPrefix + ".trigramhybrid.TrigramHybridTagger");
        taggerClassMap.put("UnigramTagger", classPrefix + ".unigram.UnigramTagger");
    }
}

