/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.DefaultPartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import java.util.Map;

public class PartOfSpeechRetaggerFactory {
    protected static Map<String, String> retaggerClassMap = MapFactory.createNewMap();

    public PartOfSpeechRetagger newPartOfSpeechRetagger() {
        String className = System.getProperty("partofspeechretagger.class");
        if (className == null) {
            className = ClassUtils.packageName(this.getClass().getName()) + "DefaultPartOfSpeechRetagger";
        }
        return this.newPartOfSpeechRetagger(className);
    }

    public PartOfSpeechRetagger newPartOfSpeechRetagger(String className) {
        PartOfSpeechRetagger partOfSpeechRetagger = null;
        try {
            partOfSpeechRetagger = (PartOfSpeechRetagger)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = retaggerClassMap.get(className);
            if (fixedClassName != null) {
                try {
                    partOfSpeechRetagger = (PartOfSpeechRetagger)Class.forName(fixedClassName).newInstance();
                }
                catch (Exception e2) {
                    System.err.println("Unable to create part of speech retagger of class " + fixedClassName + ", using default retagger.");
                    partOfSpeechRetagger = new DefaultPartOfSpeechRetagger();
                }
            }
            System.err.println("Unable to create part of speech retagger of class " + className + ", using default retagger.");
            partOfSpeechRetagger = new DefaultPartOfSpeechRetagger();
        }
        return partOfSpeechRetagger;
    }

    static {
        String classPrefix = ClassUtils.packageName(PartOfSpeechRetaggerFactory.class.getName());
        retaggerClassMap.put("DefaultPartOfSpeechRetagger", classPrefix + ".DefaultPartOfSpeechRetagger");
        retaggerClassMap.put("HeppleTagger", classPrefix + ".hepple.HeppleTagger");
        retaggerClassMap.put("Rretagger", classPrefix + ".iretagger.IRetagger");
        retaggerClassMap.put("NoopRetagger", classPrefix + ".noopretagger.NoopRetagger");
        retaggerClassMap.put("ProperNounRetagger", classPrefix + ".propernounretagger.ProperNounRetagger");
        retaggerClassMap.put("SimpleRuleBasedTagger", classPrefix + ".simplerulebased.SimpleRuleBasedTagger");
    }
}

