/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger;

import edu.northwestern.at.utils.IsCloseable;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultSuffixLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultWordLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconFactory;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.UsesLexicon;
import edu.northwestern.at.utils.corpuslinguistics.postagger.InvalidRuleException;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.DefaultPartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.ContextualSmoother;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.lexical.LexicalSmoother;
import edu.northwestern.at.utils.corpuslinguistics.postagger.transitionmatrix.TransitionMatrix;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PostTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PostTokenizerFactory;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPartOfSpeechTagger
extends IsCloseableObject
implements PartOfSpeechTagger,
IsCloseable,
UsesLexicon,
UsesLogger {
    protected Lexicon lexicon;
    protected Lexicon dynamicLexicon;
    protected TransitionMatrix transitionMatrix;
    protected String[] contextRules;
    protected String[] lexicalRules;
    protected LexicalSmoother lexicalSmoother;
    protected ContextualSmoother contextualSmoother;
    protected PartOfSpeechRetagger retagger;
    protected PartOfSpeechGuesser partOfSpeechGuesser;
    protected PostTokenizer postTokenizer;
    protected int ruleCorrections = 0;
    protected Logger logger;

    public AbstractPartOfSpeechTagger() {
        LexiconFactory lexiconFactory = new LexiconFactory();
        this.lexicon = lexiconFactory.newLexicon();
        this.dynamicLexicon = lexiconFactory.newLexicon();
        PostTokenizerFactory postTokenizerFactory = new PostTokenizerFactory();
        this.postTokenizer = postTokenizerFactory.newPostTokenizer();
        this.logger = new DummyLogger();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean usesContextRules() {
        return false;
    }

    @Override
    public boolean usesLexicalRules() {
        return false;
    }

    @Override
    public boolean usesTransitionProbabilities() {
        return false;
    }

    @Override
    public void setContextRules(String[] contextRules) throws InvalidRuleException {
        this.contextRules = contextRules;
        if (this.retagger != null) {
            this.retagger.setContextRules(contextRules);
        }
    }

    @Override
    public void setLexicalRules(String[] lexicalRules) throws InvalidRuleException {
        this.lexicalRules = lexicalRules;
        if (this.retagger != null) {
            this.retagger.setLexicalRules(lexicalRules);
        }
    }

    @Override
    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public Lexicon getDynamicLexicon() {
        return this.dynamicLexicon;
    }

    @Override
    public Lexicon getLexicon(String word) {
        Lexicon result = this.lexicon;
        if (this.partOfSpeechGuesser != null) {
            result = this.partOfSpeechGuesser.getCachedLexiconForWord(word);
        }
        return result;
    }

    @Override
    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
        if (this.retagger != null) {
            this.retagger.setLexicon(this.lexicon);
        }
    }

    @Override
    public TransitionMatrix getTransitionMatrix() {
        return this.transitionMatrix;
    }

    @Override
    public void setTransitionMatrix(TransitionMatrix transitionMatrix) {
        this.transitionMatrix = transitionMatrix;
    }

    @Override
    public PartOfSpeechGuesser getPartOfSpeechGuesser() {
        return this.partOfSpeechGuesser;
    }

    @Override
    public void setPartOfSpeechGuesser(PartOfSpeechGuesser partOfSpeechGuesser) {
        this.partOfSpeechGuesser = partOfSpeechGuesser;
    }

    @Override
    public PartOfSpeechRetagger getRetagger() {
        return this.retagger;
    }

    @Override
    public void setRetagger(PartOfSpeechRetagger retagger) {
        this.retagger = retagger;
    }

    @Override
    public List<String> getTagsForWord(String word) {
        Set<String> tagSet = null;
        if (this.lexicon.containsEntry(word)) {
            tagSet = this.lexicon.getCategoriesForEntry(word);
        } else if (this.dynamicLexicon.containsEntry(word)) {
            tagSet = this.dynamicLexicon.getCategoriesForEntry(word);
        } else {
            if (this.partOfSpeechGuesser == null) {
                this.createPartOfSpeechGuesser();
            }
            Map<String, MutableInteger> tagMap = this.partOfSpeechGuesser.guessPartsOfSpeech(word);
            tagSet = tagMap.keySet();
            for (String category : tagSet) {
                MutableInteger count = tagMap.get(category);
                this.dynamicLexicon.updateEntryCount(word, category, "*", count.intValue());
            }
        }
        List<String> result = ListFactory.createNewList(tagSet);
        return result;
    }

    @Override
    public int getTagCount(String word, String tag) {
        int result = 0;
        if (this.lexicon.containsEntry(word)) {
            result = this.lexicon.getCategoryCount(word, tag);
        } else if (this.dynamicLexicon.containsEntry(word)) {
            result = this.dynamicLexicon.getCategoryCount(word, tag);
        } else {
            this.getTagsForWord(word);
            result = this.dynamicLexicon.getCategoryCount(word, tag);
        }
        return Math.max(result, 1);
    }

    public String getMostCommonTag(String word) {
        String result = "";
        if (this.lexicon.containsEntry(word)) {
            result = this.lexicon.getLargestCategory(word);
        } else if (this.dynamicLexicon.containsEntry(word)) {
            result = this.dynamicLexicon.getLargestCategory(word);
        } else {
            this.getTagsForWord(word);
            result = this.dynamicLexicon.getLargestCategory(word);
        }
        return result;
    }

    @Override
    public List<List<AdornedWord>> tagSentences(List<List<String>> sentences) {
        List<List<AdornedWord>> output = ListFactory.createNewList();
        for (List<String> sentence : sentences) {
            output.add(this.retagWords(this.tagSentence(sentence)));
        }
        return output;
    }

    @Override
    public <T extends AdornedWord> List<List<T>> tagAdornedWordSentences(List<List<T>> sentences) {
        for (List<T> sentence : sentences) {
            this.retagWords(this.tagAdornedWordSentence(sentence));
        }
        return sentences;
    }

    @Override
    public <T extends AdornedWord> List<T> retagWords(List<T> taggedSentence) {
        if (this.retagger != null) {
            return this.retagger.retagSentence(taggedSentence);
        }
        return taggedSentence;
    }

    @Override
    public void clearRuleCorrections() {
        this.ruleCorrections = 0;
    }

    @Override
    public void incrementRuleCorrections() {
        ++this.ruleCorrections;
    }

    @Override
    public int getRuleCorrections() {
        return this.ruleCorrections;
    }

    protected void createPartOfSpeechGuesser() {
        try {
            if (this.partOfSpeechGuesser == null) {
                DefaultPartOfSpeechGuesser guesser = new DefaultPartOfSpeechGuesser();
                if (this.lexicon == null) {
                    this.setLexicon(new DefaultWordLexicon());
                }
                guesser.setWordLexicon(this.lexicon);
                guesser.setSuffixLexicon(new DefaultSuffixLexicon());
                guesser.setLogger(this.logger);
                this.setPartOfSpeechGuesser(guesser);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<AdornedWord> tagSentence(List<String> sentence) {
        List<AdornedWord> taggedSentence = ListFactory.createNewList();
        for (int i = 0; i < sentence.size(); ++i) {
            String token;
            String spelling = token = sentence.get(i);
            String standardSpelling = token;
            if (this.postTokenizer != null) {
                String[] spellings = this.postTokenizer.postTokenize(token);
                spelling = spellings[0];
                standardSpelling = spellings[1];
            }
            BaseAdornedWord word = new BaseAdornedWord(token);
            word.setSpelling(spelling);
            word.setStandardSpelling(standardSpelling);
            taggedSentence.add(word);
        }
        this.tagAdornedWordList(taggedSentence);
        return taggedSentence;
    }

    @Override
    public <T extends AdornedWord> List<T> tagAdornedWordSentence(List<T> sentence) {
        for (int i = 0; i < sentence.size(); ++i) {
            String token;
            AdornedWord word = (AdornedWord)sentence.get(i);
            String spelling = token = word.getToken();
            String standardSpelling = token;
            if (this.postTokenizer != null) {
                String[] spellings = this.postTokenizer.postTokenize(token);
                spelling = spellings[0];
                standardSpelling = spellings[1];
            }
            word.setSpelling(spelling);
            word.setStandardSpelling(standardSpelling);
        }
        this.tagAdornedWordList(sentence);
        return sentence;
    }

    @Override
    public abstract <T extends AdornedWord> List<T> tagAdornedWordList(List<T> var1);
}

