/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.partsofspeech.mapper;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.mapper.DefaultPartOfSpeechTagsMapper;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.mapper.PartOfSpeechTagsMapper;

public class PartOfSpeechTagsMapperFactory {
    public PartOfSpeechTagsMapper newPartOfSpeechTagsMapper() {
        String className = System.getProperty("partofspeechtagsmapper.class");
        if (className == null) {
            className = "DefaultPartOfSpeechTagsMapper";
        }
        return this.newPartOfSpeechTagsMapper(className);
    }

    public PartOfSpeechTagsMapper newPartOfSpeechTagsMapper(String className) {
        PartOfSpeechTagsMapper partOfSpeechTagsMapper = null;
        try {
            partOfSpeechTagsMapper = (PartOfSpeechTagsMapper)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                partOfSpeechTagsMapper = (PartOfSpeechTagsMapper)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create adorned part of speech tags of class " + fixedClassName + ", using default.");
                try {
                    partOfSpeechTagsMapper = new DefaultPartOfSpeechTagsMapper();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return partOfSpeechTagsMapper;
    }
}

