/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.partsofspeech.mapper;

import edu.northwestern.at.utils.IsCloseable;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.mapper.PartOfSpeechTagsMapper;

public abstract class AbstractPartOfSpeechTagsMapper
extends IsCloseableObject
implements PartOfSpeechTagsMapper,
IsCloseable {
    protected UTF8Properties partOfSpeechTagsMap = new UTF8Properties();
    protected String sourceTagSeparator = "|";
    protected String destinationTagSeparator = "|";
    protected String unknownTag = "unknown";

    public String getTag(String spelling, String sourceTag) {
        String result = this.unknownTag;
        if (sourceTag != null) {
            if (sourceTag.indexOf(this.sourceTagSeparator) >= 0) {
                String[] sourceTags = StringUtils.makeTokenArray(sourceTag, this.sourceTagSeparator);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < sourceTags.length; ++i) {
                    String tag = this.partOfSpeechTagsMap.getTag(sourceTags[i]);
                    if (tag == null) {
                        tag = this.unknownTag;
                    }
                    if (sb.length() > 0) {
                        sb.append(this.destinationTagSeparator);
                    }
                    sb.append(tag);
                }
                result = sb.toString();
            } else {
                result = this.partOfSpeechTagsMap.getTag(sourceTag);
                if (result == null) {
                    result = this.unknownTag;
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.partOfSpeechTagsMap.toString();
    }
}

