/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.partsofspeech;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.DefaultPartOfSpeechTags;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;

public class PartOfSpeechTagsFactory {
    public PartOfSpeechTags newPartOfSpeechTags() {
        String className = System.getProperty("partofspeechtags.class");
        if (className == null) {
            className = "DefaultPartOfSpeechTags";
        }
        return this.newPartOfSpeechTags(className);
    }

    public PartOfSpeechTags newPartOfSpeechTags(String className) {
        PartOfSpeechTags partOfSpeechTags = null;
        try {
            partOfSpeechTags = (PartOfSpeechTags)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                partOfSpeechTags = (PartOfSpeechTags)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create adorned part of speech tags of class " + fixedClassName + ", using default.");
                try {
                    partOfSpeechTags = new DefaultPartOfSpeechTags();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return partOfSpeechTags;
    }
}

