/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.partsofspeech;

import edu.northwestern.at.utils.IsCloseable;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeech;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPartOfSpeechTags
extends IsCloseableObject
implements PartOfSpeechTags,
IsCloseable {
    protected Map<String, PartOfSpeech> partOfSpeechData = MapFactory.createNewMap();
    protected Map<String, String> generalTagNames = MapFactory.createNewMap();
    protected char tagSeparator = (char)124;
    protected String tagSeparatorString = "|";

    @Override
    public void addTag(String tag, String wordClass, String majorWordClass, String lemmaWordClass, String generalTagName, String description) {
        PartOfSpeech partOfSpeech = new PartOfSpeech(tag, wordClass, majorWordClass, lemmaWordClass, generalTagName, description);
        this.partOfSpeechData.put(tag, partOfSpeech);
        if (generalTagName != null) {
            this.generalTagNames.put(generalTagName, tag);
        }
    }

    @Override
    public void addPartOfSpeech(PartOfSpeech partOfSpeech) {
        if (partOfSpeech == null) {
            return;
        }
        this.partOfSpeechData.put(partOfSpeech.getTag(), partOfSpeech);
        if (partOfSpeech.getGeneralTagName() != null) {
            this.generalTagNames.put(partOfSpeech.getGeneralTagName(), partOfSpeech.getTag());
        }
    }

    public void loadTags(InputStream tagsInputStream, String encoding) throws IOException {
        UTF8Properties tagProperties = new UTF8Properties();
        tagProperties.load(tagsInputStream);
        int tagNumber = 0;
        String tagKey = "tag" + StringUtils.intToStringWithZeroFill(tagNumber, 3);
        String tagName = tagKey + ".name";
        while (tagProperties.getProperty(tagName) != null) {
            String tag = UTF8Properties.convertInputString(tagProperties.getProperty(tagName));
            String wordClass = tagProperties.getProperty(tagKey + ".wordclass");
            String majorWordClass = tagProperties.getProperty(tagKey + ".majorwordclass");
            String generalTagName = tagProperties.getProperty(tagKey + ".generalwordclass");
            String description = tagProperties.getProperty(tagKey + ".description");
            String lemmaWordClass = tagProperties.getProperty(tagKey + ".lemmawordclass");
            this.addTag(tag, wordClass, majorWordClass, lemmaWordClass, generalTagName, description);
            tagKey = "tag" + StringUtils.intToStringWithZeroFill(++tagNumber, 3);
            tagName = tagKey + ".name";
        }
    }

    public void saveTags(String fileName) throws IOException {
        UTF8Properties posTagProperties = new UTF8Properties();
        int i = 0;
        for (PartOfSpeech posTag : this.getTags()) {
            String generalWordClass;
            String name;
            String key = "tag" + StringUtils.intToStringWithZeroFill(i, 3);
            String escapedName = name = posTag.getTag();
            if (name.equals("'")) {
                escapedName = "\\u0027";
            } else if (name.equals("\"")) {
                escapedName = "\\u0022";
            } else if (name.equals(":")) {
                escapedName = "\\u003A";
            } else if (name.length() == 1 && name.charAt(0) > '\u00ff') {
                String sc = Integer.toString(name.charAt(0), 16);
                sc = StringUtils.zeroPad(sc, 4);
                escapedName = "\\u" + sc;
            }
            posTagProperties.put(key + ".name", escapedName);
            posTagProperties.put(key + ".wordclass", posTag.getWordClass());
            posTagProperties.put(key + ".majorwordclass", posTag.getMajorWordClass());
            String lemmaWordClass = posTag.getLemmaWordClass();
            posTagProperties.put(key + ".lemmawordclass", lemmaWordClass);
            String description = posTag.getDescription();
            if (description != null && description.length() > 0) {
                posTagProperties.put(key + ".description", description);
            }
            if ((generalWordClass = posTag.getGeneralTagName()) != null && generalWordClass.length() > 0) {
                posTagProperties.put(key + ".generalwordclass", generalWordClass);
            }
            ++i;
        }
        UTF8PropertyUtils.saveUTF8Properties(posTagProperties, fileName, "");
    }

    @Override
    public String getSingularNounTag() {
        return this.generalTagNames.get("noun-singular");
    }

    @Override
    public String getPluralNounTag() {
        return this.generalTagNames.get("noun-plural");
    }

    @Override
    public String getPossessiveSingularNounTag() {
        return this.generalTagNames.get("noun-singular-possessive");
    }

    @Override
    public String getPossessivePluralNounTag() {
        return this.generalTagNames.get("noun-plural-possessive");
    }

    @Override
    public String getSingularProperNounTag() {
        return this.generalTagNames.get("noun-proper-singular");
    }

    @Override
    public String getPluralProperNounTag() {
        return this.generalTagNames.get("noun-proper-plural");
    }

    @Override
    public String getPossessiveSingularProperNounTag() {
        return this.generalTagNames.get("noun-proper-singular-possessive");
    }

    @Override
    public String getPossessivePluralProperNounTag() {
        return this.generalTagNames.get("noun-proper-plural-possessive");
    }

    @Override
    public String getCardinalNumberTag() {
        return this.generalTagNames.get("numeral-cardinal");
    }

    @Override
    public String getOrdinalNumberTag() {
        return this.generalTagNames.get("numeral-ordinal");
    }

    @Override
    public String getAdverbTag() {
        return this.generalTagNames.get("adverb");
    }

    @Override
    public String getAdjectiveTag() {
        return this.generalTagNames.get("adjective");
    }

    @Override
    public String getInterjectionTag() {
        return this.generalTagNames.get("interjection");
    }

    @Override
    public String getVerbTag() {
        return this.generalTagNames.get("verb");
    }

    @Override
    public String getVerbPastTag() {
        return this.generalTagNames.get("verb-past");
    }

    @Override
    public String getPastParticipleTag() {
        return this.generalTagNames.get("verb-past-participle");
    }

    @Override
    public String getPresentParticipleTag() {
        return this.generalTagNames.get("verb-present-participle");
    }

    @Override
    public String getSymbolTag() {
        return this.generalTagNames.get("symbol");
    }

    @Override
    public String getForeignWordTag(String language) {
        String tag = this.generalTagNames.get("foreign-word");
        if (language.equals("latin")) {
            tag = this.generalTagNames.get("foreign-latin");
        } else if (language.equals("german")) {
            tag = this.generalTagNames.get("foreign-german");
        } else if (language.equals("greek")) {
            tag = this.generalTagNames.get("foreign-greek");
        } else if (language.equals("hebrew")) {
            tag = this.generalTagNames.get("foreign-hebrew");
        } else if (language.equals("french")) {
            tag = this.generalTagNames.get("foreign-french");
        } else if (language.equals("italian")) {
            tag = this.generalTagNames.get("foreign-italian");
        }
        if (tag == null) {
            tag = this.generalTagNames.get("foreign-word");
        }
        return tag;
    }

    @Override
    public String getDescription(String tag) {
        String result = "";
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null) {
            result = partOfSpeech.getDescription();
        }
        return result;
    }

    @Override
    public String getWordClass(String tag) {
        String result = "";
        if (tag != null) {
            if (tag.indexOf(this.tagSeparatorString) >= 0 && !tag.equals(this.tagSeparatorString)) {
                result = "multiple";
            } else {
                PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
                if (partOfSpeech != null) {
                    result = partOfSpeech.getWordClass();
                }
            }
        }
        return result;
    }

    @Override
    public String getMajorWordClass(String tag) {
        String result = "";
        if (tag.indexOf(this.tagSeparatorString) >= 0 && !tag.equals(this.tagSeparatorString)) {
            result = "multiple";
        } else {
            PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
            if (partOfSpeech != null) {
                result = partOfSpeech.getMajorWordClass();
            }
        }
        return result;
    }

    @Override
    public String getLemmaWordClass(String tag) {
        String result = "";
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null && (result = partOfSpeech.getLemmaWordClass()) == null) {
            result = "none";
        }
        return result;
    }

    @Override
    public String getCorrespondingCommonNounTag(String tag) {
        String result = tag;
        if (tag.equals(this.generalTagNames.get("noun-proper-singular"))) {
            result = this.generalTagNames.get("noun-singular");
        } else if (tag.equals(this.generalTagNames.get("noun-proper-plural"))) {
            result = this.generalTagNames.get("noun-plural");
        } else if (tag.equals(this.generalTagNames.get("noun-proper-singular-possessive"))) {
            result = this.generalTagNames.get("noun-singular-possessive");
        } else if (tag.equals(this.generalTagNames.get("noun-proper-plural-possessive"))) {
            result = this.generalTagNames.get("noun-plural-possessive");
        }
        return result;
    }

    public boolean majorWordClassEquals(String tag, String majorWordClass) {
        boolean result = false;
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null) {
            result = partOfSpeech.getMajorWordClass().equalsIgnoreCase(majorWordClass);
        }
        return result;
    }

    @Override
    public String getUndeterminedTag() {
        return this.generalTagNames.get("undetermined");
    }

    @Override
    public boolean isProperNounTag(String tag) {
        boolean result = false;
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null) {
            result = partOfSpeech.getWordClass().equals("proper noun");
        }
        return result;
    }

    @Override
    public boolean isProperAdjectiveTag(String tag) {
        boolean result = false;
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null) {
            result = partOfSpeech.getWordClass().equals("proper adjective");
        }
        return result;
    }

    @Override
    public boolean isNounTag(String tag) {
        return this.majorWordClassEquals(tag, "noun");
    }

    @Override
    public boolean isSingularNounTag(String tag) {
        PartOfSpeech partOfSpeech;
        boolean result = this.isNounTag(tag);
        if (result && (partOfSpeech = this.partOfSpeechData.get(tag)) != null) {
            result = partOfSpeech.getGeneralTagName().indexOf("singular") >= 0;
        }
        return result;
    }

    @Override
    public boolean isPronounTag(String tag) {
        return this.majorWordClassEquals(tag, "pronoun");
    }

    @Override
    public boolean isPersonalPronounTag(String tag) {
        boolean result = false;
        PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
        if (partOfSpeech != null) {
            result = partOfSpeech.getWordClass().equals("personal pronoun");
        }
        return result;
    }

    @Override
    public boolean isVerbTag(String tag) {
        return this.majorWordClassEquals(tag, "verb");
    }

    @Override
    public boolean isDeterminerTag(String tag) {
        return this.majorWordClassEquals(tag, "determiner");
    }

    @Override
    public boolean isForeignWordTag(String tag) {
        return this.majorWordClassEquals(tag, "foreign");
    }

    @Override
    public List<PartOfSpeech> getTags() {
        SortedArrayList<PartOfSpeech> result = new SortedArrayList<PartOfSpeech>();
        for (String tag : this.partOfSpeechData.keySet()) {
            PartOfSpeech partOfSpeech = this.partOfSpeechData.get(tag);
            result.add(partOfSpeech);
        }
        return result;
    }

    @Override
    public boolean isNumberTag(String tag) {
        return this.majorWordClassEquals(tag, "numeral");
    }

    @Override
    public boolean isSymbolTag(String tag) {
        return this.majorWordClassEquals(tag, "symbol");
    }

    @Override
    public boolean isPunctuationTag(String tag) {
        return this.majorWordClassEquals(tag, "punctuation");
    }

    @Override
    public boolean isTag(String tag) {
        return this.partOfSpeechData.containsKey(tag);
    }

    @Override
    public boolean isCompoundTag(String tag) {
        return tag.indexOf(this.tagSeparatorString) >= 0;
    }

    @Override
    public boolean isUndeterminedTag(String tag) {
        return tag.equals(this.generalTagNames.get("undetermined"));
    }

    @Override
    public String getTagSeparator() {
        return this.tagSeparatorString;
    }

    @Override
    public String joinTags(String[] tags, String separator) {
        String result = "";
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                result = result + separator;
            }
            result = result + tags[i];
        }
        return result;
    }

    @Override
    public String joinTags(String[] tags) {
        return this.joinTags(tags, this.tagSeparatorString);
    }

    @Override
    public String[] splitTag(String tag) {
        String[] result = new String[]{tag};
        if (tag.indexOf(this.tagSeparatorString) >= 0) {
            result = StringUtils.makeTokenArray(tag, this.tagSeparatorString);
        }
        return result;
    }

    @Override
    public int countTags(String tag) {
        int result = 1;
        if (tag.length() != 1 || tag.charAt(0) != this.tagSeparator) {
            for (int i = 0; i < tag.length(); ++i) {
                if (tag.charAt(i) != this.tagSeparator) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public PartOfSpeech getTag(String tag) {
        PartOfSpeech result = null;
        if (this.partOfSpeechData.containsKey(tag)) {
            result = this.partOfSpeechData.get(tag);
        }
        return result;
    }

    public Set<String> getTagNames() {
        return new TreeSet<String>(this.partOfSpeechData.keySet());
    }

    public String toString() {
        return this.partOfSpeechData.toString();
    }
}

