/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.outputter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.outputter.AdornedWordOutputter;
import edu.northwestern.at.utils.corpuslinguistics.outputter.DefaultAdornedWordOutputter;

public class AdornedWordOutputterFactory {
    public AdornedWordOutputter newAdornedWordOutputter() {
        String className = System.getProperty("adornedwordoutputter.class");
        if (className == null) {
            className = "DefaultAdornedWordOutputter";
        }
        return this.newAdornedWordOutputter(className);
    }

    public AdornedWordOutputter newAdornedWordOutputter(String className) {
        AdornedWordOutputter adornedWordOutputter = null;
        try {
            adornedWordOutputter = (AdornedWordOutputter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                adornedWordOutputter = (AdornedWordOutputter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create adorned word outputter of class " + fixedClassName + ", using default.");
                adornedWordOutputter = new DefaultAdornedWordOutputter();
            }
        }
        return adornedWordOutputter;
    }
}

