/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.namestandardizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.namestandardizer.DefaultNameStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.namestandardizer.NameStandardizer;

public class NameStandardizerFactory {
    public NameStandardizer newNameStandardizer() {
        String className = System.getProperty("namestandardizer.class");
        if (className == null) {
            className = "DefaultNameStandardizer";
        }
        return this.newNameStandardizer(className);
    }

    public NameStandardizer newNameStandardizer(String className) {
        NameStandardizer nameStandardizer = null;
        try {
            nameStandardizer = (NameStandardizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                nameStandardizer = (NameStandardizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create name standardizer of class " + fixedClassName + ", using default.");
                nameStandardizer = new DefaultNameStandardizer();
            }
        }
        return nameStandardizer;
    }
}

