/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.namerecognizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.DefaultNameRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.NameRecognizer;

public class NameRecognizerFactory {
    public NameRecognizer newNameRecognizer() {
        String className = System.getProperty("namerecognizer.class");
        if (className == null) {
            className = "DefaultNameRecognizer";
        }
        return this.newNameRecognizer(className);
    }

    public NameRecognizer newNameRecognizer(String className) {
        NameRecognizer nameRecognizer = null;
        try {
            nameRecognizer = (NameRecognizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                nameRecognizer = (NameRecognizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create name recognizer of class " + fixedClassName + ", using default.");
                nameRecognizer = new DefaultNameRecognizer();
            }
        }
        return nameRecognizer;
    }
}

