/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.namerecognizer;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.AbstractNameRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.NamePosition;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.NameRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.DefaultPartOfSpeechTags;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameRecognizer
extends AbstractNameRecognizer
implements NameRecognizer,
UsesLogger {
    public DefaultNameRecognizer() {
        try {
            this.partOfSpeechTags = new DefaultPartOfSpeechTags();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Set<String>[] findNames(String text) {
        if (this.partOfSpeechTagger == null) {
            this.setPartOfSpeechTagger(null);
        }
        List<List<String>> sentences = this.sentenceSplitter.extractSentences(text, this.wordTokenizer);
        List taggedSentences = this.partOfSpeechTagger.tagSentences(sentences);
        return this.findNames(taggedSentences);
    }

    @Override
    public <T extends AdornedWord> Set<String>[] findNames(List<List<T>> sentences) {
        int i;
        List<NamePosition>[] positions = this.findNamePositions(sentences);
        List<NamePosition> namePositions = positions[0];
        List<NamePosition> placePositions = positions[1];
        Set<String> namesSet = SetFactory.createNewSet();
        Set<String> placesSet = SetFactory.createNewSet();
        for (i = 0; i < namePositions.size(); ++i) {
            namesSet.add(DefaultNameRecognizer.namePositionToName(sentences, namePositions.get(i)));
        }
        for (i = 0; i < placePositions.size(); ++i) {
            placesSet.add(DefaultNameRecognizer.namePositionToName(sentences, placePositions.get(i)));
        }
        Set[] result = new Set[]{namesSet, placesSet};
        return result;
    }

    @Override
    public <T extends AdornedWord> List<NamePosition>[] findNamePositions(List<List<T>> sentences) {
        List<NamePosition> namePositions = ListFactory.createNewList();
        List<NamePosition> placePositions = ListFactory.createNewList();
        for (int j = 0; j < sentences.size(); ++j) {
            NamePosition namePosition;
            List<T> sentence = sentences.get(j);
            int properNounCount = 0;
            int startingWord = -1;
            int endingWord = -1;
            int wordCount = 0;
            for (int k = 0; k < sentence.size(); ++k) {
                AdornedWord word = (AdornedWord)sentence.get(k);
                String spelling = word.getSpelling();
                String posTag = word.getPartsOfSpeech();
                if (this.partOfSpeechTags.isProperNounTag(posTag) || this.partOfSpeechTags.isNounTag(posTag) && CharUtils.isFirstLetterCapital(spelling)) {
                    if (startingWord == -1) {
                        startingWord = k;
                    }
                    endingWord = k;
                    ++wordCount;
                    if (!this.partOfSpeechTags.isProperNounTag(posTag)) continue;
                    ++properNounCount;
                    continue;
                }
                if (wordCount <= 0) continue;
                NamePosition namePosition2 = new NamePosition(j, startingWord, endingWord, properNounCount);
                if (this.validateNamePosition(sentences, namePosition2)) {
                    String name = DefaultNameRecognizer.namePositionToName(sentences, namePosition2);
                    if (this.names.isPlaceName(name)) {
                        placePositions.add(namePosition2);
                    } else {
                        namePositions.add(namePosition2);
                    }
                }
                properNounCount = 0;
                startingWord = -1;
                endingWord = -1;
                wordCount = 0;
            }
            if (wordCount <= 0 || !this.validateNamePosition(sentences, namePosition = new NamePosition(j, startingWord, endingWord, properNounCount))) continue;
            String name = DefaultNameRecognizer.namePositionToName(sentences, namePosition);
            if (this.names.isPlaceName(name)) {
                placePositions.add(namePosition);
                continue;
            }
            namePositions.add(namePosition);
        }
        List[] result = new List[]{namePositions, placePositions};
        return result;
    }

    public <T extends AdornedWord> boolean validateNamePosition(List<List<T>> sentences, NamePosition namePosition) {
        List<T> sentence = sentences.get(namePosition.sentence);
        if (((AdornedWord)sentence.get(namePosition.startingWord)).toString().equals("Will") && namePosition.endingWord > namePosition.startingWord && this.names.isNamePrefix(((AdornedWord)sentence.get(namePosition.startingWord + 1)).toString())) {
            ++namePosition.startingWord;
            --namePosition.properNounCount;
        }
        return namePosition.properNounCount > 0;
    }
}

