/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.lexicon;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;

public class LexiconFactory {
    public Lexicon newLexicon() {
        String className = System.getProperty("lexicon.class");
        if (className == null) {
            className = "DefaultLexicon";
        }
        return this.newLexicon(className);
    }

    public Lexicon newLexicon(String className) {
        Lexicon lexicon = null;
        try {
            lexicon = (Lexicon)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                lexicon = (Lexicon)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create lexicon of class " + fixedClassName + ", using default.");
                try {
                    lexicon = new DefaultLexicon();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return lexicon;
    }
}

