/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.lexicon;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconEntry;
import edu.northwestern.at.utils.corpuslinguistics.outputter.PrintStreamAdornedWordOutputter;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLexicon
extends IsCloseableObject
implements Lexicon,
UsesLogger {
    protected Map<String, LexiconEntry> lexiconMap = MapFactory.createNewMap();
    protected Map<String, MutableInteger> categoryCountsMap = MapFactory.createNewMap();
    protected Map<String, MutableInteger> uniqueEntryCountForCategoryMap = MapFactory.createNewMap();
    protected int longestEntryLength = 0;
    protected int shortestEntryLength = 0;
    protected PartOfSpeechTags partOfSpeechTags;
    protected Logger logger = new DummyLogger();

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void updateCategoryCount(String category, int count) {
        MutableInteger currentCount = this.categoryCountsMap.get(category);
        if (currentCount == null && count > 0) {
            this.categoryCountsMap.put(category, new MutableInteger(count));
        } else {
            currentCount.setValue(currentCount.intValue() + count);
            if (currentCount.intValue() <= 0) {
                this.categoryCountsMap.remove(category);
            }
        }
    }

    protected void incrementUniqueEntryCountForCategory(String category) {
        MutableInteger currentCount = this.uniqueEntryCountForCategoryMap.get(category);
        if (currentCount == null) {
            this.uniqueEntryCountForCategoryMap.put(category, new MutableInteger(1));
        } else {
            currentCount.setValue(currentCount.intValue() + 1);
        }
    }

    @Override
    public void updateEntryCount(String entry, String category, String lemma, int entryCount) {
        if (entryCount <= 0) {
            return;
        }
        LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
        if (lexiconEntry == null) {
            Map<String, MutableInteger> categoriesAndCounts = MapFactory.createNewMap();
            Map<String, String> lemmata = MapFactory.createNewMap();
            lexiconEntry = new LexiconEntry(entry, entry, 0, categoriesAndCounts, lemmata);
        }
        lexiconEntry.entryCount += entryCount;
        lexiconEntry.updateCategoryAndCount(category, entryCount);
        lexiconEntry.updateLemma(category, lemma);
        this.updateCategoryCount(category, entryCount);
        lexiconEntry.determineLargestCategory();
        this.lexiconMap.put(entry, lexiconEntry);
    }

    @Override
    public void removeEntryCategory(String entry, String category) {
        LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
        if (lexiconEntry != null) {
            int count = lexiconEntry.getCategoryCount(category);
            lexiconEntry.updateCategoryAndCount(category, -count);
            lexiconEntry.entryCount += -count;
            this.updateCategoryCount(category, -count);
            if (lexiconEntry.getCategories().length == 0) {
                this.removeEntry(entry);
            }
        }
    }

    @Override
    public void removeEntry(String entry) {
        this.lexiconMap.remove(entry);
    }

    @Override
    public void loadLexicon(URL lexiconURL, String encoding) throws IOException {
        BufferedReader lexiconReader = encoding == null ? new BufferedReader(new UnicodeReader(lexiconURL.openStream())) : new BufferedReader(new UnicodeReader(lexiconURL.openStream(), encoding));
        this.longestEntryLength = 0;
        this.shortestEntryLength = 99999;
        this.uniqueEntryCountForCategoryMap.clear();
        String line = lexiconReader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            if (tokens.length > 3) {
                String entry = tokens[0];
                int count = Integer.parseInt(tokens[1]);
                this.longestEntryLength = Math.max(this.longestEntryLength, entry.length());
                this.shortestEntryLength = Math.min(this.shortestEntryLength, entry.length());
                LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
                if (lexiconEntry == null) {
                    Map<String, MutableInteger> categoriesAndCounts = MapFactory.createNewMap();
                    Map<String, String> lemmata = MapFactory.createNewMap();
                    lexiconEntry = new LexiconEntry(entry, entry, 0, categoriesAndCounts, lemmata);
                }
                lexiconEntry.entryCount += count;
                try {
                    for (int i = 2; i < tokens.length; i += 3) {
                        String category = tokens[i];
                        String lemma = tokens[i + 1];
                        count = Integer.parseInt(tokens[i + 2]);
                        lexiconEntry.updateCategoryAndCount(category, count);
                        lexiconEntry.updateLemma(category, lemma);
                        this.updateCategoryCount(category, count);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                lexiconEntry.determineLargestCategory();
                this.lexiconMap.put(entry, lexiconEntry);
            }
            line = lexiconReader.readLine();
        }
        try {
            if (lexiconReader != null) {
                lexiconReader.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.computeUniqueEntryCountsForCategories();
    }

    protected void computeUniqueEntryCountsForCategories() {
        for (String entry : this.lexiconMap.keySet()) {
            LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
            Set<String> categories = lexiconEntry.categoriesAndCounts.keySet();
            for (String category : categories) {
                this.incrementUniqueEntryCountForCategory(category);
            }
        }
    }

    @Override
    public int getLexiconSize() {
        return this.lexiconMap.keySet().size();
    }

    @Override
    public String[] getEntries() {
        Set<String> entrySet = this.lexiconMap.keySet();
        Object[] entries = entrySet.toArray(new String[entrySet.size()]);
        Arrays.sort(entries);
        return entries;
    }

    @Override
    public String[] getCategories() {
        Set<String> categorySet = this.categoryCountsMap.keySet();
        Object[] categories = categorySet.toArray(new String[categorySet.size()]);
        Arrays.sort(categories);
        return categories;
    }

    @Override
    public boolean containsEntry(String entry) {
        return this.lexiconMap.get(entry) != null;
    }

    @Override
    public LexiconEntry getLexiconEntry(String entry) {
        LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
        if (lexiconEntry == null && CharUtils.allLettersCapital(entry)) {
            lexiconEntry = this.lexiconMap.get(CharUtils.capitalizeFirstLetter(entry));
        }
        if (lexiconEntry == null) {
            lexiconEntry = this.lexiconMap.get(entry.toLowerCase());
        }
        return lexiconEntry;
    }

    @Override
    public LexiconEntry setLexiconEntry(String entry, LexiconEntry entryData) {
        return this.lexiconMap.put(entry, entryData);
    }

    @Override
    public Set<String> getCategoriesForEntry(String entry) {
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        Set<String> categories = null;
        if (lexiconEntry != null) {
            categories = lexiconEntry.categoriesAndCounts.keySet();
        }
        if (categories == null && CharUtils.isPunctuationOrSymbol(entry)) {
            categories = new TreeSet<String>();
            categories.add(entry);
        }
        return categories;
    }

    @Override
    public Set<String> getCategoriesForEntry(List<String> sentence, int entryIndex) {
        String entry = sentence.get(entryIndex);
        return this.getCategoriesForEntry(entry);
    }

    @Override
    public Set<String> getCategoriesForEntry(String entry, boolean isFirstEntry) {
        return this.getCategoriesForEntry(entry);
    }

    @Override
    public int getNumberOfCategoriesForEntry(String entry) {
        int result = 0;
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null) {
            result = lexiconEntry.categoriesAndCounts.keySet().size();
        }
        return result;
    }

    @Override
    public String getLargestCategory(String entry) {
        String result = "";
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null) {
            result = lexiconEntry.largestCategory;
        }
        return result;
    }

    @Override
    public int getCategoryCount(String category) {
        int result = 0;
        if (this.categoryCountsMap.get(category) != null) {
            result = this.categoryCountsMap.get(category).intValue();
        }
        return result;
    }

    public int getUniqueEntryCountForCategory(String category) {
        int result = 0;
        if (this.uniqueEntryCountForCategoryMap.get(category) != null) {
            result = this.uniqueEntryCountForCategoryMap.get(category).intValue();
        }
        return result;
    }

    @Override
    public int getCategoryCount(String entry, String category) {
        MutableInteger count;
        int result = 0;
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null && (count = lexiconEntry.categoriesAndCounts.get(category)) != null) {
            result = count.intValue();
        }
        return result;
    }

    @Override
    public String getLemma(String entry) {
        String lemma;
        String result = "*";
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null && (lemma = lexiconEntry.getLemma(lexiconEntry.largestCategory)) != null) {
            result = lemma;
        }
        return result;
    }

    @Override
    public String[] getLemmata(String entry) {
        String[] result = new String[]{"*"};
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        TreeSet<String> lemmataSet = new TreeSet<String>();
        if (lexiconEntry != null) {
            Iterator<String> iterator = lexiconEntry.lemmata.keySet().iterator();
            while (iterator.hasNext()) {
                String lemma = lexiconEntry.lemmata.get(iterator.next());
                if (lemma == null) continue;
                lemmataSet.add(lemma);
            }
            result = lemmataSet.toArray(new String[lemmataSet.size()]);
        }
        return result;
    }

    @Override
    public String getLemma(String entry, String category) {
        String lemma;
        String result = "*";
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null && (lemma = lexiconEntry.getLemma(category)) != null) {
            result = lemma;
        }
        return result;
    }

    @Override
    public Map<String, MutableInteger> getCategoryCounts() {
        return this.categoryCountsMap;
    }

    @Override
    public int getNumberOfCategories() {
        return this.categoryCountsMap.keySet().size();
    }

    @Override
    public Map<String, MutableInteger> getCategoryCountsForEntry(String entry) {
        Map<String, MutableInteger> result = null;
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null) {
            result = lexiconEntry.categoriesAndCounts;
        }
        return result;
    }

    @Override
    public int getEntryCount(String entry) {
        int result = 0;
        LexiconEntry lexiconEntry = this.getLexiconEntry(entry);
        if (lexiconEntry != null) {
            result = lexiconEntry.entryCount;
        }
        return result;
    }

    @Override
    public void saveLexiconToTextFile(String lexiconFileName, String encoding) throws IOException {
        PrintStreamAdornedWordOutputter outputter = new PrintStreamAdornedWordOutputter();
        outputter.createOutputFile(lexiconFileName, encoding, '\t');
        TreeMap<String, LexiconEntry> sortedLexiconMap = new TreeMap<String, LexiconEntry>(this.lexiconMap);
        for (String entry : sortedLexiconMap.keySet()) {
            LexiconEntry lexiconEntry = this.lexiconMap.get(entry);
            outputter.outputWordAndAdornments(lexiconEntry.getLexiconEntryData());
        }
        outputter.close();
    }

    @Override
    public int getLongestEntryLength() {
        return this.longestEntryLength;
    }

    @Override
    public int getShortestEntryLength() {
        return this.shortestEntryLength;
    }

    protected boolean checkCategoriesList() {
        boolean result = true;
        String[] usedCategories = this.getCategories();
        for (int i = 0; i < usedCategories.length && result; ++i) {
            String category = usedCategories[i];
            result = result && this.partOfSpeechTags.isTag(category);
        }
        return result;
    }

    @Override
    public PartOfSpeechTags getPartOfSpeechTags() {
        return this.partOfSpeechTags;
    }

    @Override
    public boolean setPartOfSpeechTags(PartOfSpeechTags partOfSpeechTags) {
        this.partOfSpeechTags = partOfSpeechTags;
        return this.checkCategoriesList();
    }
}

