/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.lemmatizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.DefaultLemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;

public class LemmatizerFactory {
    public Lemmatizer newLemmatizer() {
        String className = System.getProperty("lemmatizer.class");
        if (className == null) {
            className = "DefaultLemmatizer";
        }
        return this.newLemmatizer(className);
    }

    public Lemmatizer newLemmatizer(String className) {
        Lemmatizer lemmatizer = null;
        try {
            lemmatizer = (Lemmatizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                lemmatizer = (Lemmatizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create lemmatizer of class " + fixedClassName + ", using default.");
                try {
                    lemmatizer = new DefaultLemmatizer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return lemmatizer;
    }
}

