/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.lemmatizer;

import edu.northwestern.at.utils.IsCloseable;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.AbstractLemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.Stemmer;
import java.util.Map;

public abstract class AbstractStemmerLemmatizer
extends AbstractLemmatizer
implements IsCloseable,
Lemmatizer {
    protected Stemmer stemmer = null;
    protected Map<String, String> stemMap = MapFactory.createNewMap();

    public void setLexicon(Lexicon lexicon) {
    }

    public String lemmatize(String spelling, String wordClass) {
        String result = "*";
        if (this.stemMap.containsKey(spelling)) {
            result = this.stemMap.get(spelling);
        } else {
            result = this.stemmer.stem(spelling);
            this.stemMap.put(spelling, result);
        }
        return result;
    }

    public String lemmatize(String spelling) {
        return this.lemmatize(spelling, "");
    }
}

