/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.lemmatizer;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.RomanNumeralUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLemmatizer
extends IsCloseableObject
implements Lemmatizer,
UsesLogger {
    protected char lemmaSeparator = (char)124;
    protected String lemmaSeparatorString = "|";
    protected Logger logger = new DummyLogger();
    protected Lexicon lexicon = null;
    protected Set<String> dictionary = null;

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    @Override
    public void setDictionary(Set<String> dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public abstract String lemmatize(String var1);

    @Override
    public abstract String lemmatize(String var1, String var2);

    @Override
    public boolean cantLemmatize(String spelling) {
        boolean result = true;
        if (spelling != null) {
            String trimmedSpelling = spelling.trim();
            result = trimmedSpelling.length() == 0 || CharUtils.isAllHyphens(trimmedSpelling) || CharUtils.hasPunctuationNotApostrophes(trimmedSpelling) || CharUtils.hasSymbols(trimmedSpelling) || CharUtils.isNumber(trimmedSpelling) || RomanNumeralUtils.isLooseRomanNumeral(trimmedSpelling) || RomanNumeralUtils.isLooseOrdinalRomanNumeral(trimmedSpelling);
        }
        return result;
    }

    @Override
    public String getLemmaSeparator() {
        return this.lemmaSeparatorString;
    }

    @Override
    public String joinLemmata(String[] lemmata, String separator) {
        String result = "";
        for (int i = 0; i < lemmata.length; ++i) {
            if (i > 0) {
                result = result + separator;
            }
            result = result + lemmata[i];
        }
        return result;
    }

    @Override
    public String joinLemmata(String[] lemmata) {
        return this.joinLemmata(lemmata, this.lemmaSeparatorString);
    }

    @Override
    public String[] splitLemma(String lemma) {
        return StringUtils.makeTokenArray(lemma, this.lemmaSeparatorString);
    }

    @Override
    public boolean isCompoundLemma(String lemma) {
        return lemma.indexOf(this.lemmaSeparatorString) >= 0;
    }

    @Override
    public int countLemmata(String lemma) {
        int result = 1;
        if (lemma.length() != 1 || lemma.charAt(0) != this.lemmaSeparator) {
            for (int i = 0; i < lemma.length(); ++i) {
                if (lemma.charAt(i) != this.lemmaSeparator) continue;
                ++result;
            }
        }
        return result;
    }
}

