/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.languagerecognizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.languagerecognizer.DefaultLanguageRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.languagerecognizer.LanguageRecognizer;

public class LanguageRecognizerFactory {
    public LanguageRecognizer newLanguageRecognizer() {
        String className = System.getProperty("languagerecognizer.class");
        if (className == null) {
            className = "DefaultLanguageRecognizer";
        }
        return this.newLanguageRecognizer(className);
    }

    public LanguageRecognizer newLanguageRecognizer(String className) {
        LanguageRecognizer languageRecognizer = null;
        try {
            languageRecognizer = (LanguageRecognizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                languageRecognizer = (LanguageRecognizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create language recognizer of class " + fixedClassName + ", using default.");
                languageRecognizer = new DefaultLanguageRecognizer();
            }
        }
        return languageRecognizer;
    }
}

