/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.languagerecognizer;

import de.spieleck.app.cngram.NGramProfiles;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.corpuslinguistics.languagerecognizer.LanguageRecognizer;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLanguageRecognizer
extends IsCloseableObject
implements LanguageRecognizer,
UsesLogger {
    protected NGramProfiles nps;
    protected NGramProfiles.Ranker ranker;
    protected NGramProfiles.RankResult rankResult;
    protected Logger logger;

    public AbstractLanguageRecognizer() {
        try {
            this.nps = new NGramProfiles();
            this.ranker = this.nps.getRanker();
            this.logger = new DummyLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbstractLanguageRecognizer(List<String> languages) {
        try {
            this.nps = new NGramProfiles(languages);
            this.ranker = this.nps.getRanker();
            this.logger = new DummyLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ScoredString[] recognizeLanguage(String text) {
        ScoredString[] result = null;
        List<ScoredString> resultList = ListFactory.createNewList();
        try {
            StringReader reader = new StringReader(text);
            this.ranker.reset();
            this.ranker.account(reader);
            this.rankResult = this.ranker.getRankResult();
            for (int i = 0; i < this.rankResult.getLength(); ++i) {
                if (!(this.rankResult.getScore(i) > 0.0)) continue;
                resultList.add(new ScoredString(this.rankResult.getName(i), this.rankResult.getScore(i)));
            }
            result = resultList.toArray(new ScoredString[resultList.size()]);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    @Override
    public void close() {
        this.rankResult = null;
        this.ranker = null;
        this.nps = null;
        System.gc();
    }
}

