/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inputter;

import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.inputter.TextInputter;
import edu.northwestern.at.utils.html.HTMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLTextInputter
extends IsCloseableObject
implements TextInputter {
    protected String loadedText = null;

    @Override
    public void loadText(URL url, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new UnicodeReader(url.openStream(), encoding));
        StringBuffer loadedTextBuffer = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            loadedTextBuffer.append(line);
            loadedTextBuffer.append(" ");
            line = reader.readLine();
        }
        reader.close();
        this.loadedText = loadedTextBuffer.toString();
        if (HTMLUtils.isHTMLTaggedText(this.loadedText)) {
            this.loadedText = HTMLUtils.stripHTMLTags(this.loadedText);
        }
    }

    @Override
    public void loadText(URL url, String encoding, String xmlSchemaURI) throws IOException {
        this.loadText(url, encoding);
    }

    @Override
    public int getSegmentCount() {
        return 1;
    }

    @Override
    public String getSegmentName(int segmentNumber) {
        String result = null;
        if (segmentNumber == 0) {
            result = "text";
        }
        return result;
    }

    @Override
    public String getSegmentText(int segmentNumber) {
        String result = null;
        if (segmentNumber == 0) {
            result = this.loadedText;
        }
        return result;
    }

    @Override
    public String getSegmentText(String segmentName) {
        String result = null;
        if (segmentName != null && segmentName.equals("text")) {
            result = this.loadedText;
        }
        return result;
    }

    @Override
    public void setSegmentText(int segmentNumber, String segmentText) {
        if (segmentNumber == 0) {
            this.loadedText = segmentText;
        }
    }

    @Override
    public void setSegmentText(String segmentName, String segmentText) {
        if (segmentName != null && segmentName.equals("text")) {
            this.loadedText = segmentText;
        }
    }

    @Override
    public void setSegmentText(int segmentNumber, File segmentTextFile) {
        if (segmentNumber == 0) {
            try {
                this.loadedText = FileUtils.readTextFile(segmentTextFile, "utf-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSegmentText(String segmentName, File segmentTextFile) {
        if (segmentName != null && segmentName.equals("text")) {
            try {
                this.loadedText = FileUtils.readTextFile(segmentTextFile, "utf-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void enableGapFixer(boolean fixGaps) {
    }

    @Override
    public void enableOrigFixer(boolean fixOrig) {
    }

    @Override
    public void enableSplitWordsFixer(boolean fixSplitWords, List<PatternReplacer> patternReplacers) {
    }
}

