/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inputter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.inputter.DefaultTextInputter;
import edu.northwestern.at.utils.corpuslinguistics.inputter.TextInputter;

public class TextInputterFactory {
    public TextInputter newTextInputter() {
        String className = System.getProperty("textinputter.class");
        if (className == null) {
            className = "DefaultTextInputter";
        }
        return this.newTextInputter(className);
    }

    public TextInputter newTextInputter(String className) {
        TextInputter textInputter = null;
        try {
            textInputter = (TextInputter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                textInputter = (TextInputter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create text inputter of class " + fixedClassName + ", using default.");
                textInputter = new DefaultTextInputter();
            }
        }
        return textInputter;
    }
}

