/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inputter;

import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.ElementProcessor;
import edu.northwestern.at.utils.xml.JDOMUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GapFixer {
    protected static final char letterGapChar = '\u25cf';
    protected static final String letterGapString = "\u25cf";
    protected static final char wordGapChar = '\u25ca';
    protected static final String wordGapString = "\u25ca";
    protected static final char spanGapChar = '\u2026';
    protected static final String spanGapString = "\u2026";

    public static void fixGaps(Document document) {
        GapFilter filter = new GapFilter();
        GapProcessor processor = new GapProcessor();
        JDOMUtils.applyElementFilter(document, filter, processor);
    }

    protected GapFixer() {
    }

    public static class GapProcessor
    implements ElementProcessor {
        public void processElement(Document document, Element gap) {
            String extent;
            boolean isWords = false;
            boolean isPage = false;
            boolean isSpan = false;
            boolean isParagraph = false;
            boolean isMissing = false;
            boolean isLetter = false;
            int count = 0;
            String desc = JDOMUtils.getAttributeValueIgnoreCase(gap, "desc");
            if (desc == null) {
                desc = "";
            }
            if ((extent = JDOMUtils.getAttributeValueIgnoreCase(gap, "extent")) == null) {
                extent = "";
            } else {
                String[] extentTokens = extent.split(" ");
                isWords = StringUtils.indexOfIgnoreCase(extentTokens[1], "word") >= 0;
                isPage = StringUtils.indexOfIgnoreCase(extentTokens[1], "page") >= 0;
                isSpan = StringUtils.indexOfIgnoreCase(extentTokens[1], "span") >= 0;
                isParagraph = StringUtils.indexOfIgnoreCase(extentTokens[1], "paragraph") >= 0;
                isMissing = StringUtils.indexOfIgnoreCase(extentTokens[1], "missing") >= 0;
                isLetter = StringUtils.indexOfIgnoreCase(extentTokens[1], "letter") >= 0;
                extentTokens[0] = StringUtils.replaceAll(extentTokens[0], "+", "");
                count = Integer.parseInt(extentTokens[0]);
            }
            String disp = JDOMUtils.getAttributeValueIgnoreCase(gap, "disp");
            if (disp == null) {
                disp = "";
            }
            if (isWords) {
                disp = GapFixer.wordGapString;
            }
            if (isSpan) {
                disp = GapFixer.spanGapString;
            }
            if (isPage || isMissing || isParagraph) {
                disp = "";
            }
            if (isLetter && disp.length() == 0) {
                disp = StringUtils.dupl(GapFixer.letterGapString, count);
            }
            disp = StringUtils.replaceAll(disp, "\u3008", "");
            disp = StringUtils.replaceAll(disp, "\u3009", "");
            if ((disp = StringUtils.replaceAll(disp, "\ufeff", "")).length() > 0) {
                gap.setText(disp);
            }
        }
    }

    public static class GapFilter
    implements Filter {
        public boolean matches(Object obj) {
            return obj instanceof Element && ((Element)obj).getName().equalsIgnoreCase("gap");
        }
    }
}

