/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inflector.wordrule;

import edu.northwestern.at.utils.corpuslinguistics.inflector.wordrule.WordRule;

public class SuffixInflectionRule
implements WordRule {
    protected final String regex;
    protected final String singularSuffix;
    protected final String pluralSuffix;

    public SuffixInflectionRule(String singularSuffix, String pluralSuffix) {
        this(singularSuffix, singularSuffix, pluralSuffix);
    }

    public SuffixInflectionRule(String suffix, String singularSuffix, String pluralSuffix) {
        this.regex = "(?i).*" + suffix.substring(1) + "$";
        this.singularSuffix = singularSuffix;
        this.pluralSuffix = pluralSuffix;
    }

    public boolean applies(String word) {
        return word.matches(this.regex);
    }

    public String apply(String word) {
        int i = word.lastIndexOf(this.singularSuffix.substring(1));
        return word.substring(0, i) + this.pluralSuffix.substring(1);
    }
}

