/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer.NoopPluralizer;
import edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer.Pluralizer;
import edu.northwestern.at.utils.corpuslinguistics.inflector.wordrule.WordRule;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedPluralizer
implements Pluralizer {
    protected static final Pluralizer NOOP_PLURALIZER = new NoopPluralizer();
    protected List<WordRule> rules;
    protected Locale locale;
    protected Pluralizer fallbackPluralizer;

    public RuleBasedPluralizer() {
        this.rules = ListFactory.createNewList();
        this.locale = Locale.getDefault();
    }

    public RuleBasedPluralizer(List<WordRule> rules, Locale locale) {
        this(rules, locale, NOOP_PLURALIZER);
    }

    public RuleBasedPluralizer(List<WordRule> rules, Locale locale, Pluralizer fallbackPluralizer) {
        this.rules = rules;
        this.locale = locale;
        this.fallbackPluralizer = fallbackPluralizer;
    }

    public Pluralizer getFallbackPluralizer() {
        return this.fallbackPluralizer;
    }

    public void setFallbackPluralizer(Pluralizer fallbackPluralizer) {
        this.fallbackPluralizer = fallbackPluralizer;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<WordRule> getRules() {
        return this.rules;
    }

    public void setRules(List<WordRule> rules) {
        this.rules = rules;
    }

    @Override
    public String pluralize(String nounOrPronoun) {
        return this.pluralize(nounOrPronoun, 2);
    }

    @Override
    public String pluralize(String nounOrPronoun, int number) {
        if (number == 1) {
            return nounOrPronoun;
        }
        Pattern pattern = Pattern.compile("\\A(\\s*)(.+?)(\\s*)\\Z");
        Matcher matcher = pattern.matcher(nounOrPronoun);
        if (matcher.matches()) {
            String pre = matcher.group(1);
            String trimmedWord = matcher.group(2);
            String post = matcher.group(3);
            String plural = this.pluralizeInternal(trimmedWord);
            if (plural == null) {
                return this.fallbackPluralizer.pluralize(nounOrPronoun, number);
            }
            return pre + this.postProcess(trimmedWord, plural) + post;
        }
        return nounOrPronoun;
    }

    protected String pluralizeInternal(String nounOrPronoun) {
        for (WordRule rule : this.rules) {
            if (!rule.applies(nounOrPronoun)) continue;
            return rule.apply(nounOrPronoun);
        }
        return null;
    }

    protected String postProcess(String trimmedWord, String pluralizedWord) {
        if (trimmedWord.matches("^\\p{Lu}+$")) {
            return pluralizedWord.toUpperCase(this.locale);
        }
        if (trimmedWord.matches("^\\p{Lu}.*")) {
            return pluralizedWord.substring(0, 1).toUpperCase(this.locale) + pluralizedWord.substring(1);
        }
        return pluralizedWord;
    }
}

