/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer.DefaultPluralizer;
import edu.northwestern.at.utils.corpuslinguistics.inflector.pluralizer.Pluralizer;

public class PluralizerFactory {
    public Pluralizer newPluralizer() {
        String className = System.getProperty("pluralizer.class");
        if (className == null) {
            className = "DefaultPluralizer";
        }
        return this.newPluralizer(className);
    }

    public Pluralizer newPluralizer(String className) {
        Pluralizer pluralizer = null;
        try {
            pluralizer = (Pluralizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                pluralizer = (Pluralizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create pluralizer of class " + fixedClassName + ", using default.");
                try {
                    pluralizer = new DefaultPluralizer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return pluralizer;
    }
}

