/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inflector.conjugator;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.inflector.conjugator.Conjugator;
import edu.northwestern.at.utils.corpuslinguistics.inflector.conjugator.DefaultConjugator;

public class ConjugatorFactory {
    public Conjugator newConjugator() {
        String className = System.getProperty("conjugator.class");
        if (className == null) {
            className = "DefaultConjugator";
        }
        return this.newConjugator(className);
    }

    public Conjugator newConjugator(String className) {
        Conjugator conjugator = null;
        try {
            conjugator = (Conjugator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                conjugator = (Conjugator)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create conjugator of class " + fixedClassName + ", using default.");
                try {
                    conjugator = new DefaultConjugator();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return conjugator;
    }
}

