/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.inflector;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.inflector.DefaultInflector;
import edu.northwestern.at.utils.corpuslinguistics.inflector.Inflector;

public class InflectorFactory {
    public Inflector newInflector() {
        String className = System.getProperty("inflector.class");
        if (className == null) {
            className = "DefaultInflector";
        }
        return this.newInflector(className);
    }

    public Inflector newInflector(String className) {
        Inflector inflector = null;
        try {
            inflector = (Inflector)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                inflector = (Inflector)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create inflector of class " + fixedClassName + ", using default.");
                try {
                    inflector = new DefaultInflector();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return inflector;
    }
}

