/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.contractionexpander;

import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.contractionexpander.AbstractContractionExpander;
import edu.northwestern.at.utils.corpuslinguistics.contractionexpander.ContractionExpander;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PennTreebankTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.WordTokenizer;
import java.io.Reader;
import java.util.List;

public class EnglishContractionExpander
extends AbstractContractionExpander
implements ContractionExpander {
    protected static String contractedSpellingsFileName = "resources/contractedspellings.txt";
    protected WordTokenizer contractionTokenizer = new PennTreebankTokenizer();

    public EnglishContractionExpander() {
        try {
            UnicodeReader reader = new UnicodeReader(this.getClass().getResourceAsStream(contractedSpellingsFileName), "utf-8");
            this.loadContractedSpellings(reader);
            ((Reader)reader).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("# of contractions read: " + this.contractedSpellings.getStringCount());
    }

    public String expandContraction(String spelling) {
        String result = spelling;
        if (this.contractedSpellings.containsString(spelling.toLowerCase())) {
            result = this.contractedSpellings.getTag(spelling.toLowerCase());
        } else {
            List<String> contractionSegments = this.contractionTokenizer.extractWords(spelling);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < contractionSegments.size(); ++i) {
                String segment;
                if (i > 0) {
                    sb.append(" ");
                }
                if (this.contractedSpellings.containsString(segment = contractionSegments.get(i))) {
                    segment = this.contractedSpellings.getTag(segment);
                }
                sb.append(segment);
            }
            result = sb.toString();
        }
        return result;
    }
}

