/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.contractionexpander;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.contractionexpander.ContractionExpander;
import edu.northwestern.at.utils.corpuslinguistics.contractionexpander.DefaultContractionExpander;

public class ContractionExpanderFactory {
    public ContractionExpander newContractionExpander() {
        String className = System.getProperty("contractionExpander.class");
        if (className == null) {
            className = "DefaultContractionExpander";
        }
        return this.newContractionExpander(className);
    }

    public ContractionExpander newContractionExpander(String className) {
        ContractionExpander contractionExpander = null;
        try {
            contractionExpander = (ContractionExpander)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                contractionExpander = (ContractionExpander)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create contraction expander of class " + fixedClassName + ", using default.");
                try {
                    contractionExpander = new DefaultContractionExpander();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return contractionExpander;
    }
}

