/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.UTF8Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class UTF8PropertyUtils {
    public static UTF8Properties loadUTF8Properties(String propertiesFileName) throws IOException, FileNotFoundException {
        UTF8Properties properties = new UTF8Properties();
        FileInputStream propertiesInputStream = new FileInputStream(propertiesFileName);
        properties.load(propertiesInputStream);
        ((InputStream)propertiesInputStream).close();
        return properties;
    }

    public static UTF8Properties loadUTF8Properties(URL propertiesURL) throws IOException, FileNotFoundException {
        UTF8Properties properties = new UTF8Properties();
        if (propertiesURL != null) {
            InputStream propertiesInputStream = propertiesURL.openStream();
            properties.load(propertiesInputStream);
            propertiesInputStream.close();
        }
        return properties;
    }

    public static UTF8Properties loadUTF8Properties(URL propertiesURL, UTF8Properties defaultProperties) throws IOException, FileNotFoundException {
        UTF8Properties properties = new UTF8Properties(defaultProperties);
        if (propertiesURL != null) {
            InputStream propertiesInputStream = propertiesURL.openStream();
            properties.load(propertiesInputStream);
            propertiesInputStream.close();
        }
        return properties;
    }

    public static void saveUTF8Properties(UTF8Properties properties, String propertiesFileName, String header) throws IOException {
        FileOutputStream propertiesFile = new FileOutputStream(propertiesFileName);
        properties.store(propertiesFile, header);
        propertiesFile.flush();
        propertiesFile.close();
    }

    public static UTF8Properties loadUTF8PropertiesFromString(String propertiesString) throws IOException {
        UTF8Properties properties = new UTF8Properties();
        properties.load(new ByteArrayInputStream(propertiesString.getBytes("UTF-8")));
        return properties;
    }

    public static void saveUTF8PropertiesToString(UTF8Properties properties, String propertiesString, String header) throws IOException {
        ByteArrayOutputStream propertiesOutputStream = new ByteArrayOutputStream();
        properties.store(propertiesOutputStream, header);
        propertiesOutputStream.flush();
        propertiesString = propertiesOutputStream.toString();
        propertiesOutputStream.close();
    }

    protected UTF8PropertyUtils() {
    }
}

