/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.CompoundKey;
import edu.northwestern.at.utils.Map2D;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap2D<K1 extends Comparable, K2 extends Comparable, V>
implements Map2D<K1, K2, V> {
    protected Map<K1, TreeMap<K2, V>> localMap = new TreeMap<K1, TreeMap<K2, V>>();

    @Override
    public void clear() {
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            Map columnMap = this.localMap.get(iterator.next());
            if (columnMap == null) continue;
            columnMap.clear();
        }
        this.localMap.clear();
    }

    @Override
    public int size() {
        int result = 0;
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            TreeMap<K2, V> columnMap = this.localMap.get(iterator.next());
            if (columnMap == null) continue;
            result += columnMap.size();
        }
        return result;
    }

    @Override
    public boolean containsKeys(Object rowKey, Object columnKey) {
        boolean result = false;
        Map map = this.localMap.get(rowKey);
        if (map != null) {
            result = map.containsKey(columnKey);
        }
        return result;
    }

    @Override
    public boolean containsKey(CompoundKey key) {
        Comparable[] keyValues;
        Map map;
        boolean result = false;
        if (key != null && (map = (Map)this.localMap.get((keyValues = key.getKeyValues())[0])) != null) {
            result = map.containsKey(keyValues[1]);
        }
        return result;
    }

    @Override
    public V get(Object rowKey, Object columnKey) {
        V result = null;
        Map map = this.localMap.get(rowKey);
        if (map != null) {
            result = map.get(columnKey);
        }
        return result;
    }

    @Override
    public V get(CompoundKey key) {
        Comparable[] keyValues;
        Map map;
        V result = null;
        if (key != null && (map = (Map)this.localMap.get((keyValues = key.getKeyValues())[0])) != null) {
            result = map.get(keyValues[1]);
        }
        return result;
    }

    @Override
    public V put(K1 rowKey, K2 columnKey, V value) {
        V previousValue = null;
        TreeMap<Object, V> map = this.localMap.get(rowKey);
        if (map != null) {
            previousValue = map.get(columnKey);
        } else {
            map = new TreeMap();
        }
        map.put(columnKey, value);
        this.localMap.put(rowKey, map);
        return previousValue;
    }

    @Override
    public V remove(Object rowKey, Object columnKey) {
        V result = null;
        Map map = this.localMap.get(rowKey);
        if (map != null && (result = (V)map.get(columnKey)) != null) {
            map.remove(columnKey);
        }
        return result;
    }

    @Override
    public Set<CompoundKey> keySet() {
        TreeSet<CompoundKey> result = new TreeSet<CompoundKey>();
        for (Comparable rowKey : this.localMap.keySet()) {
            Map colMap = this.localMap.get(rowKey);
            if (colMap == null) continue;
            for (Comparable columnKey : colMap.keySet()) {
                CompoundKey key = new CompoundKey(rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }

    @Override
    public Set<K1> rowKeySet() {
        return this.localMap.keySet();
    }

    @Override
    public Set<K2> columnKeySet() {
        TreeSet result = new TreeSet();
        for (Comparable rowKey : this.localMap.keySet()) {
            Map colMap = this.localMap.get(rowKey);
            if (colMap == null) continue;
            result.addAll(colMap.keySet());
        }
        return result;
    }

    @Override
    public Set<K2> columnKeySet(Object rowKey) {
        Set<Object> result = new TreeSet();
        Map colMap = this.localMap.get(rowKey);
        if (colMap != null) {
            result = colMap.keySet();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (CompoundKey key : this.keySet()) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(key.toString());
            sb.append("=");
            sb.append(this.get(key));
        }
        return "[" + sb.toString() + "]";
    }
}

