/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyUtils {
    public static Properties loadProperties(String propertiesFileName) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        FileInputStream propertiesInputStream = new FileInputStream(propertiesFileName);
        properties.load(propertiesInputStream);
        ((InputStream)propertiesInputStream).close();
        return properties;
    }

    public static Properties loadProperties(URL propertiesURL) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        if (propertiesURL != null) {
            InputStream propertiesInputStream = propertiesURL.openStream();
            properties.load(propertiesInputStream);
            propertiesInputStream.close();
        }
        return properties;
    }

    public static void saveProperties(Properties properties, String propertiesFileName, String header) throws IOException {
        FileOutputStream propertiesFile = new FileOutputStream(propertiesFileName);
        properties.store(propertiesFile, header);
        propertiesFile.flush();
        propertiesFile.close();
    }

    public static Properties loadPropertiesFromString(String propertiesString) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(propertiesString.getBytes("ISO-8859-1")));
        return properties;
    }

    public static void savePropertiesToString(Properties properties, String propertiesString, String header) throws IOException {
        ByteArrayOutputStream propertiesOutputStream = new ByteArrayOutputStream();
        properties.store(propertiesOutputStream, header);
        propertiesOutputStream.flush();
        propertiesString = propertiesOutputStream.toString();
        propertiesOutputStream.close();
    }

    protected PropertyUtils() {
    }
}

