/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.CompoundKey;
import edu.northwestern.at.utils.Map3D;
import edu.northwestern.at.utils.Map3DFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map3DUtils {
    public static Map3D<String, String, String, String> loadMap3D(URL map3DURL, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map3D<String, String, String, String> map3D = Map3DFactory.createNewMap3D();
        if (map3DURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(map3DURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                String[] tokens = inputLine.split(separator);
                if (tokens.length > 3) {
                    map3D.put(tokens[0], tokens[1], tokens[2], tokens[3]);
                }
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return map3D;
    }

    public static Map3D<String, String, String, String> loadMap3D(File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return Map3DUtils.loadMap3D(mapFile.toURI().toURL(), separator, qualifier, encoding);
    }

    public static Map3D<String, String, String, String> loadMap3D(String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return Map3DUtils.loadMap3D(new File(mapFileName), separator, qualifier, encoding);
    }

    public static void saveMap3D(Map3D<?, ?, ?, ?> map3D, File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        if (map3D != null) {
            PrintWriter printWriter = new PrintWriter(mapFile, "utf-8");
            for (CompoundKey key : map3D.keySet()) {
                String value = map3D.get(key).toString();
                Comparable[] keyValues = key.getKeyValues();
                printWriter.println(qualifier + keyValues[0] + qualifier + separator + qualifier + keyValues[1] + qualifier + separator + qualifier + keyValues[2] + qualifier + separator + qualifier + value + qualifier);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveMap3D(Map3D<?, ?, ?, ?> map3D, String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map3DUtils.saveMap3D(map3D, new File(mapFileName), separator, qualifier, encoding);
    }

    protected Map3DUtils() {
    }
}

