/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.CompoundKey;
import edu.northwestern.at.utils.Map3D;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap3D<K1 extends Comparable, K2 extends Comparable, K3 extends Comparable, V>
implements Map3D<K1, K2, K3, V> {
    protected Map<K1, Map<K2, Map<K3, V>>> localMap;

    public HashMap3D() {
        this.localMap = MapFactory.createNewMap();
    }

    public HashMap3D(int initialCapacity) {
        this.localMap = MapFactory.createNewMap(initialCapacity);
    }

    @Override
    public void clear() {
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            Map<K2, Map<K3, V>> columnMap = this.localMap.get(iterator.next());
            if (columnMap == null) continue;
            Iterator<K2> iterator2 = columnMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Map<K3, V> sliceMap = columnMap.get(iterator2.next());
                if (sliceMap == null) continue;
                sliceMap.clear();
            }
            columnMap.clear();
        }
        this.localMap.clear();
    }

    @Override
    public int size() {
        int result = 0;
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            Map<K2, Map<K3, V>> columnMap = this.localMap.get(iterator.next());
            if (columnMap == null) continue;
            Iterator<K2> iterator2 = columnMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Map<K3, V> sliceMap = columnMap.get(iterator2.next());
                if (sliceMap == null) continue;
                result += sliceMap.size();
            }
        }
        return result;
    }

    @Override
    public boolean containsKeys(Object rowKey, Object columnKey, Object sliceKey) {
        Map<K3, V> sliceMap;
        boolean result = false;
        Map<K2, Map<K3, V>> columnMap = this.localMap.get(rowKey);
        if (columnMap != null && (sliceMap = columnMap.get(columnKey)) != null) {
            result = sliceMap.containsKey(sliceKey);
        }
        return result;
    }

    @Override
    public boolean containsKey(CompoundKey key) {
        Comparable[] keyValues = key.getKeyValues();
        return this.containsKeys(keyValues[0], keyValues[1], keyValues[2]);
    }

    @Override
    public V get(Object rowKey, Object columnKey, Object sliceKey) {
        Map<K3, V> sliceMap;
        V result = null;
        Map<K2, Map<K3, V>> columnMap = this.localMap.get(rowKey);
        if (columnMap != null && (sliceMap = columnMap.get(columnKey)) != null) {
            result = sliceMap.get(sliceKey);
        }
        return result;
    }

    @Override
    public V get(CompoundKey key) {
        Comparable[] keyValues = key.getKeyValues();
        return this.get(keyValues[0], keyValues[1], keyValues[2]);
    }

    @Override
    public V put(K1 rowKey, K2 columnKey, K3 sliceKey, V value) {
        V previousValue = null;
        Map columnMap = this.localMap.get(rowKey);
        Map sliceMap = null;
        if (columnMap != null) {
            sliceMap = columnMap.get(columnKey);
            if (sliceMap != null) {
                previousValue = sliceMap.get(sliceKey);
            } else {
                sliceMap = MapFactory.createNewMap();
            }
        } else {
            columnMap = MapFactory.createNewMap();
            sliceMap = MapFactory.createNewMap();
        }
        sliceMap.put(sliceKey, value);
        columnMap.put(columnKey, sliceMap);
        this.localMap.put(rowKey, columnMap);
        return previousValue;
    }

    @Override
    public V remove(Object rowKey, Object columnKey, Object sliceKey) {
        Map<K3, V> sliceMap;
        V result = null;
        Map<K2, Map<K3, V>> columnMap = this.localMap.get(rowKey);
        if (columnMap != null && (sliceMap = columnMap.get(columnKey)) != null) {
            result = sliceMap.get(sliceKey);
            sliceMap.remove(sliceKey);
        }
        return result;
    }

    @Override
    public Set<CompoundKey> keySet() {
        Set<CompoundKey> result = SetFactory.createNewSet();
        for (Comparable rowKey : this.localMap.keySet()) {
            Map<K2, Map<K3, V>> columnMap = this.localMap.get(rowKey);
            if (columnMap == null) continue;
            for (Comparable columnKey : columnMap.keySet()) {
                Map<K3, V> sliceMap = columnMap.get(columnKey);
                if (sliceMap == null) continue;
                for (Comparable sliceKey : sliceMap.keySet()) {
                    CompoundKey key = new CompoundKey(rowKey, columnKey, sliceKey);
                    result.add(key);
                }
            }
        }
        return result;
    }

    @Override
    public Set<K1> rowKeySet() {
        Set<K1> rowSet = SetFactory.createNewSet();
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            rowSet.add(iterator.next());
        }
        return rowSet;
    }

    @Override
    public Set<K2> columnKeySet() {
        Set<K2> columnSet = SetFactory.createNewSet();
        Iterator<K1> iterator = this.localMap.keySet().iterator();
        while (iterator.hasNext()) {
            Iterator<K2> iterator2 = this.localMap.get(iterator.next()).keySet().iterator();
            while (iterator2.hasNext()) {
                columnSet.add(iterator2.next());
            }
        }
        return columnSet;
    }

    @Override
    public Set<K3> sliceKeySet() {
        Set<Comparable> sliceSet = SetFactory.createNewSet();
        for (CompoundKey key : this.keySet()) {
            sliceSet.add(key.getKeyValues()[2]);
        }
        return sliceSet;
    }

    @Override
    public Iterator<CompoundKey> iterator() {
        return this.keySet().iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (CompoundKey key : this.keySet()) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(key.toString());
            sb.append("=");
            sb.append(this.get(key));
        }
        return "[" + sb.toString() + "]";
    }
}

