/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.math.NumberOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountMapUtils {
    public static double[] getSummaryCountsFromCountMap(Map<? extends Object, ? extends Number> map) {
        double[] result = new double[]{0.0, 0.0, map.size()};
        Set<? extends Object> keyset = map.keySet();
        Iterator<? extends Object> iterator = keyset.iterator();
        while (iterator.hasNext()) {
            double dCount = map.get(iterator.next()).doubleValue();
            result[0] = result[0] + dCount;
            result[1] = result[1] + dCount * dCount;
        }
        return result;
    }

    public static int getTotalWordCount(Map<? extends Object, ? extends Number> map) {
        int result = 0;
        Set<? extends Object> keyset = map.keySet();
        Iterator<? extends Object> iterator = keyset.iterator();
        while (iterator.hasNext()) {
            int count = map.get(iterator.next()).intValue();
            result += count;
        }
        return result;
    }

    public static double getSumOfCrossProducts(Map<? extends Object, ? extends Number> countMap1, Map<? extends Object, ? extends Number> countMap2) {
        double result = 0.0;
        if (countMap1.size() > countMap2.size()) {
            for (Object object : countMap2.keySet()) {
                if (!countMap1.containsKey(object)) continue;
                Number count1 = countMap1.get(object);
                Number count2 = countMap2.get(object);
                result += NumberOps.multiply(count1, count2).doubleValue();
            }
        } else {
            for (Object object : countMap1.keySet()) {
                if (!countMap2.containsKey(object)) continue;
                Number count1 = countMap1.get(object);
                Number count2 = countMap2.get(object);
                result += NumberOps.multiply(count1, count2).doubleValue();
            }
        }
        return result;
    }

    public static <K> Map<K, Number> booleanizeCountMap(Map<K, ? extends Number> map) {
        TreeMap<K, Integer> result = new TreeMap<K, Integer>();
        for (K key : map.keySet()) {
            double dCount = map.get(key).doubleValue();
            int binValue = dCount == 0.0 ? 0 : 1;
            result.put(key, new Integer(binValue));
        }
        return result;
    }

    public static <K> Map<K, Number> scaleCountMap(Map<K, ? extends Number> map, double scaleFactor) {
        TreeMap<K, Double> result = new TreeMap<K, Double>();
        for (K key : map.keySet()) {
            double dCount = map.get(key).doubleValue();
            result.put(key, new Double(dCount * scaleFactor));
        }
        return result;
    }

    public static <K> Set<K> getWordsFromMap(Map<K, ?> map) {
        return new TreeSet<K>(map.keySet());
    }

    public static String[] splitKeyedCountString(String s2) {
        String[] tokens = new String[]{"", "0"};
        if (s2 == null) {
            return tokens;
        }
        if (s2.length() == 0) {
            return tokens;
        }
        int tabPos = s2.indexOf("\t");
        if (tabPos < 0) {
            tokens[0] = s2;
        } else {
            tokens[0] = s2.substring(0, tabPos).trim();
            tokens[1] = s2.substring(tabPos + 1).trim();
        }
        return tokens;
    }

    public static <K> void addCountMap(Map<K, Number> destinationMap, Map<K, Number> sourceMap) {
        for (K key : sourceMap.keySet()) {
            Number sourceCount = sourceMap.get(key);
            if (!destinationMap.containsKey(key)) {
                destinationMap.put(key, NumberOps.add(sourceCount, new Double(0.0)));
                continue;
            }
            Number destCount = destinationMap.get(key);
            destCount = NumberOps.add(sourceCount, destCount);
            destinationMap.put(key, destCount);
        }
    }

    public static <K> void incrementCountMap(Map<K, Number> destinationMap, Map<K, Number> sourceMap) {
        for (K key : sourceMap.keySet()) {
            Number sourceCount = sourceMap.get(key);
            if (!destinationMap.containsKey(key)) {
                destinationMap.put(key, new Integer(1));
                continue;
            }
            Number destCount = destinationMap.get(key);
            destinationMap.put(key, NumberOps.add(destCount, new Integer(1)));
        }
    }

    public static <K> void subtractCountMap(Map<K, Number> destinationMap, Map<K, Number> sourceMap) {
        for (K key : sourceMap.keySet()) {
            Number sourceCount = sourceMap.get(key);
            if (!destinationMap.containsKey(key)) continue;
            Number destCount = destinationMap.get(key);
            Number updatedDestCount = NumberOps.subtract(destCount, sourceCount);
            if (NumberOps.compareToZero(updatedDestCount) > 0) {
                destinationMap.put(key, updatedDestCount);
                continue;
            }
            destinationMap.remove(key);
        }
    }

    public static <K> List getWordsInCommon(Map<K, ? extends Number> countMap1, Map<K, ? extends Number> countMap2) {
        SortedArrayList<K> result = new SortedArrayList<K>();
        if (countMap1.size() > countMap2.size()) {
            for (K key : countMap2.keySet()) {
                if (!countMap1.containsKey(key)) continue;
                result.add(key);
            }
        } else {
            for (K key : countMap1.keySet()) {
                if (!countMap2.containsKey(key)) continue;
                result.add(key);
            }
        }
        return result;
    }

    public static <K> int getCountOfWordsInCommon(Map<K, ? extends Number> countMap1, Map<K, ? extends Number> countMap2) {
        int result = 0;
        if (countMap1.size() > countMap2.size()) {
            for (K key : countMap2.keySet()) {
                if (!countMap1.containsKey(key)) continue;
                ++result;
            }
        } else {
            for (K key : countMap1.keySet()) {
                if (!countMap2.containsKey(key)) continue;
                ++result;
            }
        }
        return result;
    }

    public static <K> int getWordCount(Map<K, ? extends Number> countMap, K word) {
        int result = 0;
        if (countMap.containsKey(word)) {
            result = countMap.get(word).intValue();
        }
        return result;
    }

    public static <K> void updateWordCountMap(K word, int count, Map<K, Number> countMap) {
        Number newCount = countMap.containsKey(word) ? (Number)NumberOps.add(countMap.get(word), new Integer(count)) : (Number)new Integer(count);
        countMap.put(word, newCount);
    }

    public static <V extends Number> Map<String, Number> convertKeysToStrings(Map<? extends Object, V> countMap) {
        TreeMap<String, Number> result = new TreeMap<String, Number>();
        for (Object object : countMap.keySet()) {
            Number value = (Number)countMap.get(object);
            String copyKey = null;
            if (object != null) {
                try {
                    copyKey = object.toString();
                }
                catch (Exception e) {
                    copyKey = null;
                }
            }
            if (copyKey == null) continue;
            result.put(copyKey, value);
        }
        return result;
    }

    public static Map<String, Number> loadCountMapFromReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        Map<String, Number> result = MapFactory.createNewMap();
        String countLine = bufferedReader.readLine();
        while (countLine != null) {
            String[] tokens = countLine.split("\t");
            int count = Integer.parseInt(tokens[1]);
            result.put(tokens[0], count);
            countLine = bufferedReader.readLine();
        }
        bufferedReader.close();
        return result;
    }

    public static Map<String, Number> loadCountMapFromFile(File file) throws IOException {
        return CountMapUtils.loadCountMapFromReader(new FileReader(file));
    }

    public static <K, V extends Number> Map<String, Number> semiDeepClone(Map<K, V> countMap) {
        Map<String, Number> result = MapFactory.createNewMap(countMap.size());
        for (K key : countMap.keySet()) {
            Number value = (Number)countMap.get(key);
            String copyKey = null;
            Number copyValue = null;
            if (key != null) {
                try {
                    copyKey = new String(key.toString());
                }
                catch (Exception e) {
                    copyKey = null;
                }
                copyValue = value != null ? (Number)NumberOps.cloneNumber(value) : (Number)new Integer(0);
            }
            if (copyKey == null) continue;
            result.put(copyKey, copyValue);
        }
        return result;
    }

    protected CountMapUtils() {
    }
}

