/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.SetFactory;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharUtils {
    protected static Set<Integer> punctuationSet = SetFactory.createNewSet();
    protected static Set<Integer> symbolSet = SetFactory.createNewSet();
    public static final char LSQUOTE = '\u2018';
    public static final String LSQUOTE_STRING = "\u2018";
    public static final char RSQUOTE = '\u2019';
    public static final String RSQUOTE_STRING = "\u2019";
    public static final char LDQUOTE = '\u201c';
    public static final String LDQUOTE_STRING = "\u201c";
    public static final char RDQUOTE = '\u201d';
    public static final String RDQUOTE_STRING = "\u201d";
    public static final char SOLIDCIRCLE = '\u2022';
    public static final String SOLIDCIRCLE_STRING = "\u2022";
    public static final char BLACKCIRCLE = '\u25cf';
    public static final String BLACKCIRCLE_STRING = "\u25cf";
    public static final char DEGREES_MARK = '\u2032';
    public static final char MINUTES_MARK = '\u2033';
    public static final char SECONDS_MARK = '\u2034';
    public static final char CHAR_GAP_MARKER = '\u25cf';
    public static final String CHAR_GAP_MARKER_STRING = "\u25cf";
    public static final char CHAR_END_OF_TEXT_SECTION = '\ue500';
    public static final String CHAR_END_OF_TEXT_SECTION_STRING = "\ue500";
    public static final char CHAR_FAKE_SOFT_HYPHEN = '\ue501';
    public static final String CHAR_FAKE_SOFT_HYPHEN_STRING = "\ue501";
    public static final char CHAR_SUBSTITUTE_SINGLE_QUOTE = '\ue502';
    public static final String CHAR_SUBSTITUTE_SINGLE_QUOTE_STRING = "\ue502";
    public static final char CHAR_SUP_TEXT_MARKER = '\ue503';
    public static final String CHAR_SUP_TEXT_MARKER_STRING = "\ue503";
    public static final char LONG_DASH = '\u2014';
    public static final String LONG_DASH_STRING = "\u2014";
    public static final char SHORT_DASH = '\u2010';
    public static final String SHORT_DASH_STRING = "\u2010";
    public static final char OLD_EURO_SIGN = '\u20a0';
    public static final char EURO_SIGN = '\u20ac';
    public static final char UNKNOWN_PUNC = '\u25aa';
    public static final char COMBINING_MACRON = '\u0304';
    public static final String COMBINING_MACRON_STRING = "\u0304";
    public static final char NONBREAKING_BLANK = '\u00a0';
    public static final String NONBREAKING_BLANK_STRING = "\u00a0";
    public static final char NONBREAKING_HYPHEN = '\u2011';
    public static final String NONBREAKING_HYPHEN_STRING = "\u2011";
    public static final char VERTICAL_BAR = '|';
    public static final String VERTICAL_BAR_STRING = "|";
    public static final char BROKEN_VERTICAL_BAR = '\u00a6';
    public static final String BROKEN_VERTICAL_BAR_STRING = "\u00a6";
    public static final char LIGHT_VERTICAL_BAR = '\u2758';
    public static final String LIGHT_VERTICAL_BAR_STRING = "\u2758";
    public static String digitsPattern = "[0-9]*";
    public static String ordinalNumberPattern = "[0-9][0-9,]*(th|TH|st|ST|nd|ND|rd|RD)";
    protected static final Pattern hyphenPattern = Pattern.compile("^([-\u2011]{1,})$");
    protected static final Matcher hyphenMatcher = hyphenPattern.matcher("");
    protected static final Pattern asteriskPattern = Pattern.compile("^(\\*{1,})$");
    protected static final Matcher asteriskMatcher = asteriskPattern.matcher("");
    protected static final Pattern possessiveAsteriskPattern = Pattern.compile("^(\\*{1,})'(s|S)$");
    protected static final Matcher possessiveAsteriskMatcher = possessiveAsteriskPattern.matcher("");
    protected static final Pattern possessiveDashesPattern = Pattern.compile("^([-\u2011]{2,})'(s|S)$");
    protected static final Matcher possessiveDashesMatcher = possessiveDashesPattern.matcher("");
    protected static final Pattern wordPattern = Pattern.compile("([\\w]+|([\\w]+-[\\w]+)+|[\\w]*'[\\w]*)");
    protected static final Matcher wordMatcher = wordPattern.matcher("");

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isLetter(String s2) {
        return s2 != null && s2.length() == 1 && Character.isLetter(s2.charAt(0));
    }

    public static boolean isLetters(String s2) {
        boolean result = false;
        if (s2 != null) {
            result = true;
            String ts = s2.trim();
            for (int i = 0; i < ts.length(); ++i) {
                if (CharUtils.isLetter(ts.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isAWord(String s2) {
        boolean result = false;
        if (s2 != null && !s2.equals("'")) {
            wordMatcher.reset(s2);
            result = wordMatcher.matches();
        }
        return result;
    }

    public static boolean isCapitalLetter(char c) {
        return Character.isLetter(c) && Character.isUpperCase(c);
    }

    public static boolean isPunctuation(char ch) {
        return punctuationSet.contains(new Integer(Character.getType(ch))) || ch == '`' || ch == '\u25aa';
    }

    public static boolean isPunctuation(String s2) {
        boolean result = true;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isPunctuation(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isSymbol(char ch) {
        return symbolSet.contains(new Integer(Character.getType(ch)));
    }

    public static boolean isSymbol(String s2) {
        boolean result = true;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isSymbol(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isPunctuationOrSymbol(char c) {
        return CharUtils.isPunctuation(c) || CharUtils.isSymbol(c);
    }

    public static boolean isPunctuationOrSymbol(String s2) {
        boolean result = true;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isPunctuationOrSymbol(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isDigits(String s2) {
        if (s2 == null) {
            return false;
        }
        boolean result = true;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isDigit(s2.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean hasDigit(String s2) {
        if (s2 == null) {
            return false;
        }
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (!CharUtils.isDigit(s2.charAt(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isDash(char c) {
        return Character.getType(c) == 20;
    }

    public static boolean isBreakingDash(char c) {
        return CharUtils.isDash(c) && c != '\u2011';
    }

    public static boolean hasDash(String s2) {
        boolean result = false;
        for (int i = 0; i < s2.length(); ++i) {
            boolean bl = result = Character.getType(s2.charAt(i)) == 20;
            if (result) break;
        }
        return result;
    }

    public static String evictDashes(String s2) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.getType(s2.charAt(i)) == 20) continue;
            result.append(s2.charAt(i));
        }
        return result.toString();
    }

    public static boolean isNumber(String s2) {
        boolean result = false;
        if (s2 != null) {
            try {
                double x = Double.parseDouble(s2);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isOrdinal(String s2) {
        boolean result = false;
        if (s2 != null) {
            result = s2.matches(ordinalNumberPattern);
        }
        return result;
    }

    public static boolean allLettersCapital(String s2) {
        boolean result = false;
        String ts = s2.trim();
        int l = ts.length();
        for (int i = 0; i < l; ++i) {
            char ch = ts.charAt(i);
            if (!Character.isLetter(ch)) continue;
            if (!Character.isUpperCase(ch)) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    public static boolean isUpperCase(String s2) {
        boolean result = true;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (Character.isUpperCase(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isFirstLetterCapital(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (!Character.isLetter(ts.charAt(i))) continue;
            result = Character.isUpperCase(ts.charAt(i));
            break;
        }
        return result;
    }

    public static boolean hasPunctuation(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isPunctuation(ch) || ch == '-') continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean hasPunctuationNotApostrophes(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isPunctuation(ch) || ch == '-' || ch == '\'') continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean hasSymbols(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isSymbol(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isGapMarker(char c) {
        return c == '\u25cf';
    }

    public static boolean hasGapMarkers(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isGapMarker(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isGreekLetter(char c) {
        return c >= '\u0370' && c < '\u0400' || c >= '\u1f00' && c < '\u2000';
    }

    public static boolean hasGreekLetters(String s2) {
        boolean result = false;
        String ts = s2.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isGreekLetter(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isEnglishVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    public static boolean isSingleQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u2019';
    }

    public static boolean isApostrophe(char c) {
        return c == '\'';
    }

    public static boolean isSingleOpeningQuote(char c) {
        return c == '\'' || c == '\u2018';
    }

    public static boolean endsWithSingleQuoteS(String s2) {
        int l = s2.length();
        return l > 1 && (s2.charAt(l - 1) == 's' || s2.charAt(l - 1) == 'S') && CharUtils.isSingleQuote(s2.charAt(l - 2));
    }

    public static boolean isSingleQuoteS(String s2) {
        int l = s2.length();
        return l == 2 && CharUtils.isSingleQuote(s2.charAt(0)) && (s2.charAt(1) == 's' || s2.charAt(1) == 'S');
    }

    public static boolean endsWithSingleQuote(String s2) {
        int l = s2.length();
        return l > 0 && CharUtils.isSingleQuote(s2.charAt(l - 1));
    }

    public static boolean isOpeningQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u201c';
    }

    public static boolean isClosingQuote(char c) {
        return c == '\'' || c == '\"' || c == '\u2019' || c == '\u201d';
    }

    public static boolean hasSingleQuote(String s2) {
        boolean result = false;
        for (int i = 0; i < s2.length(); ++i) {
            boolean bl = result = result || CharUtils.isSingleQuote(s2.charAt(i));
            if (result) break;
        }
        return result;
    }

    public static boolean isAllCaps(String s2) {
        boolean result = true;
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (!Character.isLetter(ch)) continue;
            boolean bl = result = result && Character.isUpperCase(ch);
            if (!result) break;
        }
        return result;
    }

    public static boolean isAllLowerCase(String s2) {
        boolean result = true;
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (!Character.isLetter(ch)) continue;
            boolean bl = result = result && Character.isLowerCase(ch);
            if (!result) break;
        }
        return result;
    }

    public static boolean hasCapitalLetter(String s2) {
        boolean result = false;
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            boolean bl = result = result || Character.isLetter(ch) && Character.isUpperCase(ch);
            if (result) break;
        }
        return result;
    }

    public static boolean hasApostrophe(String s2) {
        return s2.indexOf("'") >= 0;
    }

    public static boolean hasInternalCaps(String s2) {
        boolean result = false;
        for (int i = 1; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            boolean bl = result = result || Character.isLetter(ch) && Character.isUpperCase(ch);
            if (result) break;
        }
        return result;
    }

    public static boolean isAllPeriods(String s2) {
        return s2.matches("^(\\.{1,})$");
    }

    public static synchronized boolean isAllHyphens(String s2) {
        hyphenMatcher.reset(s2);
        return hyphenMatcher.matches();
    }

    public static synchronized boolean isAllAsterisks(String s2) {
        asteriskMatcher.reset(s2);
        return asteriskMatcher.matches();
    }

    public static synchronized boolean isPossessiveAsterisks(String s2) {
        possessiveAsteriskMatcher.reset(s2);
        return possessiveAsteriskMatcher.matches();
    }

    public static synchronized boolean isPossessiveDashes(String s2) {
        possessiveDashesMatcher.reset(s2);
        return possessiveDashesMatcher.matches();
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    public static String makeCaseMatch(String s2, String sCaseToMatch) {
        String result = s2;
        if (CharUtils.isAllCaps(sCaseToMatch)) {
            result = result.toUpperCase();
        } else {
            boolean isCapitalized = false;
            if (sCaseToMatch.length() > 0) {
                isCapitalized = CharUtils.isSingleQuote(sCaseToMatch.charAt(0)) ? sCaseToMatch.length() > 1 && CharUtils.isCapitalLetter(sCaseToMatch.charAt(1)) : CharUtils.isCapitalLetter(sCaseToMatch.charAt(0));
            }
            if (result.length() > 0) {
                if (CharUtils.isSingleQuote(result.charAt(0))) {
                    String char0 = result.charAt(0) + "";
                    String rest = "";
                    if (result.length() > 1) {
                        char char1 = result.charAt(1);
                        if (result.length() > 2) {
                            rest = result.substring(2);
                        }
                        result = isCapitalized ? char0 + Character.toUpperCase(char1) + rest : char0 + Character.toLowerCase(char1) + rest;
                    }
                } else {
                    String rest = "";
                    char char0 = result.charAt(0);
                    if (result.length() > 1) {
                        rest = result.substring(1);
                    }
                    result = isCapitalized ? Character.toUpperCase(char0) + rest : Character.toLowerCase(char0) + rest;
                }
            }
        }
        return result;
    }

    public static String capitalizeFirstLetter(String s2) {
        char[] chars = s2.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (!Character.isLetter(ch)) continue;
            chars[i] = Character.toUpperCase(ch);
            break;
        }
        return new String(chars);
    }

    public static boolean isUSCurrency(String token) {
        return token.matches("^\\s*[$]?\\s*((\\d+)|(\\d{1,3}(\\,\\d{3})+))(\\.\\d{2})?\\s*$");
    }

    public static boolean isUSCurrencyCents(String token) {
        return token.matches("([\\+\\-]*)([0-9\\,]+)\u00c2\u00a2$");
    }

    public static boolean isCurrency(String token) {
        return token.matches("^-?[\u00c2\u00a3\\$L\u20ac ]*[0-9\\.\\,]+[lL]*$");
    }

    public static String getCaseOld(String s2) {
        String result = "0";
        if (CharUtils.allLettersCapital(s2)) {
            result = "3";
        } else if (CharUtils.isFirstLetterCapital(s2)) {
            result = "1";
        } else if (CharUtils.hasInternalCaps(s2)) {
            result = "2";
        }
        return result;
    }

    public static int getLetterCase(String s2) {
        int result = 0;
        int capLetCount = 0;
        int letCount = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (!Character.isLetter(ch)) continue;
            ++letCount;
            if (!Character.isUpperCase(ch)) continue;
            if (letCount == 1) {
                result = 1;
            }
            ++capLetCount;
        }
        if (letCount == capLetCount) {
            result = 3;
        } else if (result == 0 && capLetCount > 0) {
            result = 2;
        }
        return result;
    }

    protected CharUtils() {
    }

    static {
        punctuationSet.add(new Integer(23));
        punctuationSet.add(new Integer(20));
        punctuationSet.add(new Integer(7));
        punctuationSet.add(new Integer(22));
        punctuationSet.add(new Integer(30));
        punctuationSet.add(new Integer(29));
        punctuationSet.add(new Integer(24));
        punctuationSet.add(new Integer(14));
        punctuationSet.add(new Integer(21));
        symbolSet.add(new Integer(26));
        symbolSet.add(new Integer(25));
        symbolSet.add(new Integer(27));
        symbolSet.add(new Integer(28));
        symbolSet.add(new Integer(18));
    }
}

