/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.xgtagger;

import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XGOptions {
    Vector<String> vectorSoftTags = new Vector();
    Vector<String> vectorJumpTags = new Vector();
    String strFieldDelimiters = " \t";
    String strWordDelimiters = "\n";
    String strSpecialSeparator;
    String strSurroundMarker = "\ue500";
    int intPath = 0;
    boolean boolLog;
    boolean boolIds = false;
    boolean boolVerbose = false;
    boolean boolMergeEntities = true;
    boolean boolTreatAllEntities = false;
    boolean boolEntityIgnoreFiles = false;
    boolean boolRepeatAttributes = true;
    String strId;
    String strTagsPath;
    String strWordPath;
    int intWordField;
    String strRelativeURIBase = null;
    String strWordTagName;
    Properties properties;
    boolean ignoreTagCase = true;

    protected void log(String strText, int intType) throws IOException {
        switch (intType) {
            case -1: {
                MorphAdornerLogger.logError(strText);
                break;
            }
            case 0: {
                MorphAdornerLogger.logDebug(strText);
                break;
            }
            default: {
                MorphAdornerLogger.logInfo(strText);
            }
        }
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public Object setProperty(String s1, String s2) {
        return this.properties.setProperty(s1, s2);
    }

    public void setWordTagName(String s2) {
        this.strWordTagName = s2;
    }

    public void setWordField(int i) {
        this.intWordField = i;
    }

    protected void setJumpTags(Vector<String> v) {
        this.vectorJumpTags = v;
    }

    protected void setSoftTags(Vector<String> v) {
        this.vectorSoftTags = v;
    }

    public void setJumpTags(String tags) {
        String[] splitTags = tags.split("\\s");
        this.vectorJumpTags.clear();
        for (int i = 0; i < splitTags.length; ++i) {
            if (splitTags[i].length() <= 0) continue;
            if (this.ignoreTagCase) {
                splitTags[i] = splitTags[i].toLowerCase();
            }
            this.vectorJumpTags.add(splitTags[i]);
        }
    }

    public void setSoftTags(String tags) {
        String[] splitTags = tags.split("\\s");
        this.vectorSoftTags.clear();
        for (int i = 0; i < splitTags.length; ++i) {
            if (splitTags[i].length() <= 0) continue;
            if (this.ignoreTagCase) {
                splitTags[i] = splitTags[i].toLowerCase();
            }
            this.vectorSoftTags.add(splitTags[i]);
        }
    }

    public void setFieldDelimiters(String s2) {
        this.strFieldDelimiters = s2;
    }

    public void setWordDelimiters(String s2) {
        this.strWordDelimiters = s2;
    }

    public void setSpecialSeparator(String s2) {
        this.strSpecialSeparator = s2;
    }

    public void setIdArgumentName(String s2) {
        this.strId = s2;
    }

    public void setSurroundMarker(String s2) {
        this.strSurroundMarker = s2;
    }

    public void setTagsPathArgumentName(String s2) {
        this.strTagsPath = s2;
    }

    public void setWordPathArgumentName(String s2) {
        this.strWordPath = s2;
    }

    public void setWritePath(int i) {
        this.intPath |= i;
    }

    public void setWriteLog(boolean b) {
        this.boolLog = b;
    }

    public void setVerbose(boolean b) {
        this.boolVerbose = b;
    }

    public void repeatAttributes(boolean b) {
        this.boolRepeatAttributes = b;
    }

    public void setRelativeURIBase(String str) {
        this.strRelativeURIBase = str;
    }

    public void setEntityMerging(boolean b) {
        this.boolMergeEntities = b;
    }

    public void setEntityTreatAll(boolean b) {
        this.boolTreatAllEntities = b;
    }

    public void setEntityIgnoreFiles(boolean b) {
        this.boolEntityIgnoreFiles = b;
    }

    public void setWriteIds(boolean b) {
        this.boolIds = b;
    }

    public void setIgnoreTagCase(boolean ignoreTagCase) {
        this.ignoreTagCase = ignoreTagCase;
    }

    public String getProperty(String str) {
        return this.properties.getProperty(str);
    }

    public Vector<String> getJumpTags() {
        return this.vectorJumpTags;
    }

    public Vector<String> getSoftTags() {
        return this.vectorSoftTags;
    }

    public boolean isSoftTag(String strTagName) {
        boolean result = this.ignoreTagCase ? this.vectorSoftTags.contains(strTagName.toLowerCase()) : this.vectorSoftTags.contains(strTagName);
        return result;
    }

    public boolean isJumpTag(String strTagName) {
        boolean result = this.ignoreTagCase ? this.vectorJumpTags.contains(strTagName.toLowerCase()) : this.vectorJumpTags.contains(strTagName);
        return result;
    }

    public String getSurroundMarker() {
        return this.strSurroundMarker;
    }

    public String getFieldDelimiters() {
        return this.strFieldDelimiters;
    }

    public String getWordDelimiters() {
        return this.strWordDelimiters;
    }

    public String getSpecialSeparator() {
        return this.strSpecialSeparator;
    }

    public int getWritePath() {
        return this.intPath;
    }

    public boolean getWriteLog() {
        return this.boolLog;
    }

    public boolean getWriteIds() {
        return this.boolIds;
    }

    public boolean isVerbose() {
        return this.boolVerbose;
    }

    public boolean repeatAttributes() {
        return this.boolRepeatAttributes;
    }

    public boolean getEntityMerging() {
        return this.boolMergeEntities;
    }

    public boolean getEntityTreatAll() {
        return this.boolTreatAllEntities;
    }

    public boolean getEntityIgnoreFiles() {
        return this.boolEntityIgnoreFiles;
    }

    public String getRelativeURIBase() {
        return this.strRelativeURIBase;
    }

    public String getWordTagName() {
        return this.strWordTagName;
    }

    public int getWordField() {
        return this.intWordField;
    }

    public String getIdArgumentName() {
        return this.strId;
    }

    public String getTagsPathArgumentName() {
        return this.strTagsPath;
    }

    public String getWordPathArgumentName() {
        return this.strWordPath;
    }

    public boolean getIgnoreTagCase() {
        return this.ignoreTagCase;
    }

    public boolean isOutputDirectory() {
        return false;
    }
}

