/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.validatexmlfiles;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler {
    protected int errorCount = 0;

    public void resetErrorCount() {
        this.errorCount = 0;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.printError(e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.printError(e);
        ++this.errorCount;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.printError(e);
        ++this.errorCount;
        throw e;
    }

    protected void printError(SAXParseException e) {
        int lineNumber = e.getLineNumber();
        int columnNumber = e.getColumnNumber();
        if (lineNumber >= 0) {
            System.out.print("  Line " + lineNumber);
        }
        if (columnNumber >= 0) {
            if (lineNumber >= 0) {
                System.out.print(", ");
            }
            System.out.print("Column " + columnNumber);
        }
        if (lineNumber >= 0 || columnNumber >= 0) {
            System.out.print(": ");
        }
        System.out.println(e.getMessage());
    }
}

