/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.validatexmlfiles;

import edu.northwestern.at.morphadorner.tools.validatexmlfiles.ValidationErrorHandler;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;

public class ValidateXMLFiles {
    protected static Schema schema = null;
    protected static Validator validator = null;
    protected static ValidationErrorHandler errorHandler = new ValidationErrorHandler();

    public static void main(String[] args) {
        if (!ValidateXMLFiles.initialize(args)) {
            System.exit(1);
        }
        long startTime = System.currentTimeMillis();
        int filesProcessed = ValidateXMLFiles.processFiles(args);
        long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        ValidateXMLFiles.terminate(filesProcessed, processingTime);
    }

    protected static boolean initialize(String[] args) {
        boolean result = false;
        if (args.length < 1) {
            System.err.println("No files to validate provided.");
        } else {
            String schemaURIString = args[0];
            String lcSchemaURIString = schemaURIString.toLowerCase();
            if (schemaURIString.endsWith(".rng") || schemaURIString.endsWith(".xsd")) {
                try {
                    SchemaFactory schemaFactory = null;
                    if (schemaURIString.endsWith(".rng")) {
                        schemaFactory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
                    } else if (schemaURIString.endsWith(".xsd")) {
                        schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    }
                    if (schemaFactory != null) {
                        schema = schemaFactory.newSchema(new StreamSource(schemaURIString));
                        validator = schema.newValidator();
                        validator.setErrorHandler(errorHandler);
                        System.out.println("Schema " + schemaURIString + " processed.");
                        boolean bl = result = args.length > 1;
                        if (!result) {
                            System.out.println("No files to validate provided.");
                        }
                    } else {
                        result = true;
                    }
                }
                catch (Exception e) {
                    System.err.println("Bad schema file: ");
                    System.err.println(e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processOneFile(String xmlFileName) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new UnicodeReader(new FileInputStream(xmlFileName), "utf-8"));
            InputSource inputSource = new InputSource(bufferedReader);
            SAXSource source = new SAXSource(inputSource);
            if (validator != null) {
                errorHandler.resetErrorCount();
                validator.validate(source);
                if (errorHandler.getErrorCount() > 0) {
                    System.out.println(xmlFileName + " failed validation.");
                } else {
                    System.out.println(xmlFileName + " passed validation.");
                }
            } else {
                System.out.println(xmlFileName + " passed validation.");
            }
        }
        catch (Exception e) {
            System.out.print(xmlFileName + " failed validation: ");
            System.out.println(e.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static int processFiles(String[] args) {
        boolean result = false;
        int schemaBias = schema == null ? 0 : 1;
        String[] wildCards = new String[args.length - schemaBias];
        for (int i = schemaBias; i < args.length; ++i) {
            wildCards[i - schemaBias] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        for (int i = 0; i < fileNames.length; ++i) {
            ValidateXMLFiles.processOneFile(fileNames[i]);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + StringUtils.pluralize(filesProcessed, " file in ", " files in ") + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
    }
}

