/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.sampletextfile;

import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class SampleTextFile {
    public SampleTextFile(String inputFileName, String outputFileName, double sample) {
        try {
            this.setupSampling(inputFileName, outputFileName, sample);
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(inputFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName, true), "utf-8"));
            String inputLine = in.readLine();
            while (inputLine != null && !this.samplingDone()) {
                if (this.lineSelected()) {
                    printWriter.println(inputLine);
                }
                inputLine = in.readLine();
            }
            in.close();
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    public SampleTextFile(String inputFileName, String outputFileName, int sample) {
        this(inputFileName, outputFileName, (double)sample);
    }

    protected abstract void setupSampling(String var1, String var2, double var3);

    protected abstract boolean lineSelected();

    public boolean samplingDone() {
        return false;
    }
}

