/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.sampletextfile;

import edu.northwestern.at.morphadorner.tools.sampletextfile.SampleTextFile;
import edu.northwestern.at.utils.math.randomnumbers.RandomVariable;

public class RandomlySampleTextFile
extends SampleTextFile {
    protected double samplingPercentage;

    public static void main(String[] args) {
        try {
            double samplingPercentage;
            if (args.length < 3) {
                System.err.println("Too few arguments.");
                RandomlySampleTextFile.help();
                System.exit(1);
            }
            if ((samplingPercentage = Double.parseDouble(args[2])) < 0.0 || samplingPercentage > 100.0) {
                System.err.println("Bad percent -- must be from 0 through 100.");
                System.exit(1);
            }
            new RandomlySampleTextFile(args[0], args[1], samplingPercentage /= 100.0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void help() {
        System.out.println();
        System.out.println("java edu.northwestern.at.morphadorner.tools.sampletextfile.RandomlySampleTextFile input.txt output.txt samplingpercent");
        System.out.println();
        System.out.println("   input.txt -- input text file to be sampled.");
        System.out.println("   output.txt -- output text file.");
        System.out.println("   samplingpercent -- sampling percent from 0 through 100.");
    }

    public RandomlySampleTextFile(String inputFileName, String outputFileName, double sample) {
        super(inputFileName, outputFileName, sample);
    }

    protected void setupSampling(String inputFileName, String outputFileName, double sample) {
        this.samplingPercentage = sample;
    }

    protected boolean lineSelected() {
        return RandomVariable.rand() <= this.samplingPercentage;
    }
}

