/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.mergetextfiles;

import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class MergeTextFiles {
    protected static final int INITPARAMS = 1;
    protected static int filesToProcess = 0;
    protected static int currentFileNumber = 0;
    protected static int totalLines = 0;
    protected static String mergedOutputFileName = "";

    public static void main(String[] args) {
        int filesProcessed = 0;
        long processingTime = 0L;
        try {
            if (!MergeTextFiles.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            filesProcessed = MergeTextFiles.processFiles(args);
            processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        MergeTextFiles.terminate(filesProcessed, processingTime);
    }

    protected static boolean initialize(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Not enough parameters.");
            return false;
        }
        mergedOutputFileName = args[0];
        return true;
    }

    protected static void processOneFile(String inputFileName, String outputFileName) {
        System.out.println("Processing " + inputFileName + " (" + ++currentFileNumber + "/" + filesToProcess + ")");
        try {
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(inputFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName, true), "utf-8"));
            String inputLine = in.readLine();
            while (inputLine != null) {
                ++totalLines;
                printWriter.println(inputLine);
                inputLine = in.readLine();
            }
            in.close();
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    protected static int processFiles(String[] args) throws Exception {
        boolean result = false;
        String[] wildCards = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            wildCards[i - 1] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        filesToProcess = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            MergeTextFiles.processOneFile(fileNames[i], mergedOutputFileName);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatLongWithCommas(totalLines) + StringUtils.pluralize(totalLines, " line in ", " liness in ") + Formatters.formatIntegerWithCommas(filesProcessed) + StringUtils.pluralize(filesProcessed, " file in ", " files in ") + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
    }
}

