/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.mergespellingdata;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.outputter.PrintStreamAdornedWordOutputter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSpellingData {
    public static void main(String[] args) {
        try {
            MergeSpellingData.mergeSpellingData(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean isDBNull(String s2) {
        return s2 == null || s2.equals("\\N") || s2.equals("NULL");
    }

    protected static void mergeSpellingData(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: MergeSpellingData combinedoutput spellinginput1 spellinginput2 ...");
            System.out.println("");
            System.out.println("       -- combinedoutput is name of file to received combined alternate/standard spellings");
            System.out.println("       -- spellinginput1 ... are names of  files containing alternative spellings mapped to standard spellings.");
            System.exit(1);
        }
        String spellingDataOutputFileName = args[0];
        TreeMap<String, String> alternateSpellings = new TreeMap<String, String>();
        Set<String> standardSpellings = SetFactory.createNewSet();
        for (int i = 1; i < args.length; ++i) {
            String altSpellingsFileName = args[i];
            try {
                MergeSpellingData.getAlternateSpellings(new BufferedReader(new UnicodeReader(new FileInputStream(altSpellingsFileName), "utf-8")), alternateSpellings, standardSpellings);
                System.out.println("Merged alternate spellings from " + altSpellingsFileName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Unable to load alternate spellings from " + altSpellingsFileName + ".");
                System.exit(1);
            }
        }
        System.out.println("There are " + alternateSpellings.size() + " alternate spellings.");
        System.out.println("There are " + standardSpellings.size() + " standard spellings.");
        PrintStreamAdornedWordOutputter outputter = null;
        try {
            outputter = new PrintStreamAdornedWordOutputter();
            outputter.createOutputFile(spellingDataOutputFileName, "utf-8", '\t');
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to open output file " + spellingDataOutputFileName + " .");
            System.exit(1);
        }
        for (String alternateSpelling : alternateSpellings.keySet()) {
            String standardSpelling = (String)alternateSpellings.get(alternateSpelling);
            outputter.outputWordAndAdornments(new String[]{alternateSpelling, standardSpelling});
        }
        outputter.close();
    }

    public static void getAlternateSpellings(Reader reader, Map<String, String> map, Set<String> set) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String inputLine = bufferedReader.readLine();
        while (inputLine != null) {
            String[] tokens = inputLine.split("\t");
            if (tokens.length > 1) {
                String alternateSpelling = tokens[0];
                String standardSpelling = tokens[1];
                if (!MergeSpellingData.isDBNull(standardSpelling)) {
                    alternateSpelling = alternateSpelling.trim();
                    standardSpelling = standardSpelling.trim();
                    if (map.get(alternateSpelling) == null && !alternateSpelling.endsWith("-")) {
                        map.put(alternateSpelling, standardSpelling);
                        set.add(standardSpelling);
                    }
                }
            } else {
                System.out.println("Skipping line = <" + inputLine + ">");
            }
            inputLine = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    protected MergeSpellingData() {
    }
}

