/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.mergeenhancedbrilllexicon;

import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.BaseLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.BrillLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconEntry;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.NUPOSPartOfSpeechTags;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class MergeEnhancedBrillLexicon {
    public static void mergeEnhancedBrillLexicon(String lexiconFileName, String brillLexiconFileName, String mergedLexiconFileName) throws IOException {
        BaseLexicon lexicon = new BaseLexicon();
        lexicon.loadLexicon(new File(lexiconFileName).toURI().toURL(), "utf-8");
        NUPOSPartOfSpeechTags partOfSpeechTags = new NUPOSPartOfSpeechTags();
        System.out.println("MorphAdorner lexicon has " + Formatters.formatIntegerWithCommas(lexicon.getLexiconSize()) + " entries.");
        BrillLexicon brillLexicon = new BrillLexicon(new File(brillLexiconFileName).toURI().toURL(), "utf-8");
        System.out.println("Enhanced Brill lexicon has " + Formatters.formatIntegerWithCommas(brillLexicon.size()) + " entries.");
        for (String word : brillLexicon.keySet()) {
            int firstFreq = 2;
            int otherFreq = 1;
            String lemma = "*";
            if (lexicon.containsEntry(word)) continue;
            List posTags = (List)brillLexicon.get(word);
            String posTag = (String)posTags.get(0);
            lemma = (String)posTags.get(1);
            if (posTags.size() == 2 && partOfSpeechTags.isProperNounTag(posTag)) {
                String lowerCaseWord = word.toLowerCase();
                if (lexicon.containsEntry(lowerCaseWord)) {
                    LexiconEntry lexEntry = lexicon.getLexiconEntry(lowerCaseWord).deepClone();
                    lexEntry.entry = word;
                    lexicon.setLexiconEntry(word, lexEntry);
                }
                firstFreq = 1;
            }
            for (int i = 0; i < posTags.size(); i += 2) {
                lexicon.updateEntryCount(word, (String)posTags.get(i), (String)posTags.get(i + 1), i == 0 ? firstFreq : otherFreq);
            }
        }
        lexicon.saveLexiconToTextFile(mergedLexiconFileName, "utf-8");
        System.out.println("Merged lexicon has " + Formatters.formatIntegerWithCommas(lexicon.getLexiconSize()) + " entries.");
    }

    public static void main(String[] args) {
        try {
            MergeEnhancedBrillLexicon.mergeEnhancedBrillLexicon(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected MergeEnhancedBrillLexicon() {
    }
}

